/*
 * Decompiled with CFR 0.152.
 */
package org.tahomarobotics.robot.motion;

import java.util.ArrayList;
import java.util.List;
import org.tahomarobotics.robot.motion.MotionProfile;
import org.tahomarobotics.robot.motion.TrapezoidalMotionProfile;
import org.tahomarobotics.robot.path.Waypoint;

public class MotionProfileFactory {
    private static List<MotionSection> createMotionSections(List<Waypoint> waypoints) {
        ArrayList<MotionSection> sections = new ArrayList<MotionSection>();
        double len = 0.0;
        double max = waypoints.get((int)1).speed;
        Waypoint prev = waypoints.get(0);
        for (int i = 1; i < waypoints.size(); ++i) {
            Waypoint next = waypoints.get(i);
            MotionSection section = new MotionSection(prev.distance(next), next.speed);
            if (max != section.maxVelocity) {
                sections.add(new MotionSection(len, max));
                len = 0.0;
            }
            max = section.maxVelocity;
            len += section.length;
            prev = next;
        }
        sections.add(new MotionSection(len, max));
        return sections;
    }

    public static List<MotionProfile> createMotionProfiles(List<Waypoint> waypoints, Profile profile, double maxAccel, double maxJerk) {
        List<MotionSection> sections = MotionProfileFactory.createMotionSections(waypoints);
        ArrayList<MotionProfile> profiles = new ArrayList<MotionProfile>();
        double startTime = 0.0;
        double startVelocity = 0.0;
        double startPosition = 0.0;
        for (int i = 0; i < sections.size(); ++i) {
            MotionSection section = sections.get(i);
            double endPosition = startPosition + section.length;
            double maxVelocity = section.maxVelocity;
            double nextVelocity = i + 1 < sections.size() ? sections.get((int)(i + 1)).maxVelocity : 0.0;
            double endVelocity = Math.min(maxVelocity, nextVelocity);
            MotionProfile motionProfile = MotionProfileFactory.createMotionProfile(profile, startTime, startPosition, endPosition, startVelocity, endVelocity, maxVelocity, maxAccel, maxJerk);
            profiles.add(motionProfile);
            startTime = motionProfile.getEndTime();
            startVelocity = endVelocity;
            startPosition = endPosition;
        }
        return profiles;
    }

    public static MotionProfile createMotionProfile(Profile profile, double startTime, double startPosition, double endPosition, double startVelocity, double endVelocity, double maxVelocity, double maxAccel, double maxJerk) {
        try {
            switch (profile) {
                case Trapezoid: {
                    return new TrapezoidalMotionProfile(startTime, startPosition, endPosition, startVelocity, endVelocity, maxVelocity, maxAccel);
                }
            }
        }
        catch (MotionProfile.MotionProfileException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static class MotionSection {
        public final double length;
        public final double maxVelocity;

        public MotionSection(double length, double maxVelocity) {
            this.length = length;
            this.maxVelocity = maxVelocity;
        }

        public String toString() {
            return String.format("%5.1f %3.0f", this.length, this.maxVelocity);
        }
    }

    public static enum Profile {
        Trapezoid,
        SCurve;

    }
}

