/*
 * Decompiled with CFR 0.152.
 */
package org.tahomarobotics.robot.motion;

import java.util.List;
import org.tahomarobotics.robot.motion.MotionProfile;
import org.tahomarobotics.robot.motion.MotionState;

public class MotionProfiles {
    private final List<MotionProfile> fwdMotionProfiles;
    private final List<MotionProfile> rotMotionProfiles;
    private int index = 0;
    private final double totalDuration;
    private final MotionState lastForwardSetpoint;
    private final MotionState lastRotationSetpoint;

    public MotionProfiles(List<MotionProfile> motionProfiles) {
        this(motionProfiles, null);
    }

    public MotionProfiles(List<MotionProfile> fwdMotionProfiles, List<MotionProfile> rotMotionProfiles) {
        this.fwdMotionProfiles = fwdMotionProfiles;
        this.rotMotionProfiles = rotMotionProfiles;
        MotionProfile lastProfile = fwdMotionProfiles.get(fwdMotionProfiles.size() - 1);
        this.totalDuration = lastProfile.getEndTime();
        this.lastForwardSetpoint = lastProfile.getLastMotionState();
        if (rotMotionProfiles != null) {
            lastProfile = rotMotionProfiles.get(rotMotionProfiles.size() - 1);
            this.lastRotationSetpoint = lastProfile.getLastMotionState();
        } else {
            this.lastRotationSetpoint = null;
        }
    }

    public void reset() {
        this.index = 0;
    }

    public boolean getSetpoint(double elapsedTime, MotionState setpoint) {
        return this.getSetpoint(elapsedTime, setpoint, null);
    }

    public boolean getSetpoint(double elapsedTime, MotionState setpoint, MotionState rotSetpoint) {
        while (elapsedTime < this.totalDuration) {
            if (this.fwdMotionProfiles.get(this.index).getSetpoint(elapsedTime, setpoint)) {
                if (rotSetpoint != null) {
                    this.rotMotionProfiles.get(this.index).getSetpoint(elapsedTime, rotSetpoint);
                }
                return false;
            }
            if (++this.index < this.fwdMotionProfiles.size()) continue;
        }
        setpoint.copy(this.lastForwardSetpoint);
        if (rotSetpoint != null) {
            rotSetpoint.copy(this.lastRotationSetpoint);
        }
        return true;
    }

    public double getTotalDuration() {
        return this.totalDuration;
    }
}

