/*
 * Decompiled with CFR 0.152.
 */
package org.tahomarobotics.robot.motion;

import org.tahomarobotics.robot.motion.MotionProfile;
import org.tahomarobotics.robot.motion.MotionState;

public class TrapezoidalMotionProfile
extends MotionProfile {
    public TrapezoidalMotionProfile(double startTime, double startPosition, double endPosition, double startVelocity, double endVelocity, double maxVelocity, double maxAcceleration) throws MotionProfile.MotionProfileException {
        super(startTime, startPosition, endPosition, startVelocity, endVelocity, maxVelocity, maxAcceleration);
    }

    @Override
    protected MotionState[] generatePhases() throws MotionProfile.MotionProfileException {
        double tv;
        double distance = this.endPosition - this.startPosition;
        double abs_distance = Math.abs(distance);
        double direction = Math.signum(distance);
        double max_velocity = Math.min(this.maxVelocity, Math.sqrt(abs_distance * this.maxAcceleration + this.startVelocity * this.startVelocity / 2.0 + this.endVelocity * this.endVelocity / 2.0));
        double ta = (max_velocity - direction * this.startVelocity) / this.maxAcceleration;
        double td = (max_velocity - direction * this.endVelocity) / this.maxAcceleration;
        double d = tv = abs_distance > 0.0 ? (abs_distance - 0.5 * ta * (max_velocity + direction * this.startVelocity) - 0.5 * td * (max_velocity + direction * this.endVelocity)) / max_velocity : 0.0;
        if (tv < 0.0 && tv > -1.0E-4) {
            tv = 0.0;
        }
        if (ta < 0.0 || td < 0.0 || tv < 0.0) {
            throw new MotionProfile.MotionProfileException(this, String.format("Failed to resolve constraint while creating Trapezoidal profile ta=%f td=%f tv=%f \n%s", ta, td, tv, this));
        }
        double max_acceleration = direction * this.maxAcceleration;
        MotionState[] phases = new MotionState[4];
        MotionState initial = phases[0] = new MotionState().setTime(this.startTime).setPosition(this.startPosition).setVelocity(this.startVelocity).setAcceleration(max_acceleration);
        initial = phases[1] = this.getPhaseSetpoint(ta, initial, new MotionState()).setVelocity(max_velocity *= direction).setAcceleration(0.0);
        initial = phases[2] = this.getPhaseSetpoint(tv, initial, new MotionState()).setAcceleration(-max_acceleration);
        initial = phases[3] = this.getPhaseSetpoint(td, initial, new MotionState()).setVelocity(this.endVelocity).setPosition(this.endPosition).setAcceleration(0.0);
        return phases;
    }
}

