/*
 * Decompiled with CFR 0.152.
 */
package org.tahomarobotics.robot.path;

import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tahomarobotics.robot.path.CompletionListener;
import org.tahomarobotics.robot.path.PathController;
import org.tahomarobotics.robot.path.Waypoint;
import org.tahomarobotics.robot.state.Pose2D;

public class AdaptivePurePursuitController
implements PathController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdaptivePurePursuitController.class);
    private final Path path;
    private final double lookAheadDistance;
    private boolean complete = false;
    private double remainingDistance;
    private final double totalDistance;

    public AdaptivePurePursuitController(List<Waypoint> waypoints, double lookAheadDistance) {
        this.path = new Path(waypoints);
        this.lookAheadDistance = lookAheadDistance;
        this.path.start(new CompletionListener(){

            @Override
            public void onCompletion() {
                LOGGER.info("Finished path.");
                AdaptivePurePursuitController.this.complete = true;
            }
        });
        this.totalDistance = this.remainingDistance = this.path.getRemainingDistance();
    }

    public void reset() {
        this.complete = false;
        this.path.start(new CompletionListener(){

            @Override
            public void onCompletion() {
                LOGGER.info("Finished path.");
                AdaptivePurePursuitController.this.complete = true;
            }
        });
        this.remainingDistance = this.path.getRemainingDistance();
    }

    public boolean isComplete() {
        return this.complete;
    }

    public double getDistance() {
        return this.totalDistance - this.remainingDistance;
    }

    @Override
    public double update(Pose2D pose) {
        double pathError = this.path.update(pose);
        if (this.isComplete()) {
            return 0.0;
        }
        Waypoint lookAheadPoint = this.path.getLookAheadPoint(this.lookAheadDistance + pathError);
        this.remainingDistance = this.path.getRemainingDistance();
        double curvature = this.getJoinCurvature(pose, lookAheadPoint);
        Waypoint closest = this.path.getClosestPoint();
        LOGGER.debug(String.format("Cmd: %7.3f Robot: %7.3f %7.3f %7.3f Path: %7.3f %7.3f Remaining: %7.3f Lookahead Point %7.3f %7.3f", curvature, pose.x, pose.y, pose.heading, closest.x, closest.y, this.remainingDistance, lookAheadPoint.x, lookAheadPoint.y));
        SmartDashboard.putNumberArray((String)"LookAhead", (double[])new double[]{pose.x, pose.y, pose.heading, curvature, lookAheadPoint.x, lookAheadPoint.y});
        return curvature;
    }

    private double getJoinCurvature(Pose2D pose, Waypoint lookAheadPoint) {
        double dx = lookAheadPoint.x - pose.x;
        double dy = lookAheadPoint.y - pose.y;
        double heading = Math.toRadians(pose.heading);
        double x = dy * Math.cos(heading) - dx * Math.sin(heading);
        double curvature = 2.0 * x / (dx * dx + dy * dy);
        return Double.isNaN(curvature) ? 0.0 : curvature;
    }

    private class Segment {
        private final Waypoint start;
        private final Waypoint end;
        private double progress = 0.0;
        private boolean complete = false;
        private final double dx;
        private final double dy;
        private final double lengthSquared;
        private final double length;
        private final Waypoint closest = new Waypoint();
        private double pathError = 0.0;

        private Segment(Waypoint start, Waypoint end) {
            this.start = start;
            this.end = end;
            this.dx = end.x - start.x;
            this.dy = end.y - start.y;
            this.lengthSquared = this.dx * this.dx + this.dy * this.dy;
            this.length = Math.sqrt(this.lengthSquared);
        }

        private Waypoint update(Pose2D currentPosition) {
            double calculatedProgress;
            double dx = currentPosition.x - this.start.x;
            double dy = currentPosition.y - this.start.y;
            this.progress = calculatedProgress = (this.dx * dx + this.dy * dy) / this.lengthSquared;
            calculatedProgress = Math.max(0.0, calculatedProgress);
            this.closest.x = this.start.x + calculatedProgress * this.dx;
            this.closest.y = this.start.y + calculatedProgress * this.dy;
            double xerror = this.closest.x - currentPosition.x;
            double yerror = this.closest.y - currentPosition.y;
            this.pathError = Math.sqrt(xerror * xerror + yerror * yerror);
            if (calculatedProgress >= 1.0) {
                this.complete = true;
                this.end.fireCaptureEvent();
            }
            return this.closest;
        }

        private boolean isComplete() {
            return this.complete;
        }

        private double getPathError() {
            return this.pathError;
        }

        private double getRemainingLength() {
            return (1.0 - this.progress) * this.length;
        }

        private Waypoint getPoint(double distance) {
            double portion = this.progress + distance / this.length;
            Waypoint pt = new Waypoint();
            pt.x = this.start.x + portion * this.dx;
            pt.y = this.start.y + portion * this.dy;
            return pt;
        }
    }

    private class Path {
        private final LinkedList<Segment> segments = new LinkedList();
        private final List<Waypoint> waypoints;
        private final Waypoint closestPoint = new Waypoint();

        public Path(List<Waypoint> waypoints) {
            this.waypoints = waypoints;
        }

        private List<Waypoint> getWaypoints() {
            return new ArrayList<Waypoint>(this.waypoints);
        }

        private void start(CompletionListener listener) {
            this.start(listener, this.getWaypoints());
        }

        private void start(CompletionListener listener, List<Waypoint> waypoints) {
            this.segments.clear();
            Waypoint prev = null;
            for (Waypoint next : waypoints) {
                if (prev != null) {
                    this.segments.add(new Segment(prev, next));
                }
                prev = next;
            }
            prev.addCompletionListener(listener);
        }

        private Waypoint getLookAheadPoint(double lookAheadDistance) {
            double remainingDistance;
            Segment segment = null;
            ListIterator iter = this.segments.listIterator();
            while (iter.hasNext() && !(lookAheadDistance < (remainingDistance = (segment = (Segment)iter.next()).getRemainingLength()))) {
                if (!iter.hasNext()) continue;
                lookAheadDistance -= remainingDistance;
            }
            return segment == null ? new Waypoint() : segment.getPoint(lookAheadDistance);
        }

        private double update(Pose2D currentPosition) {
            ListIterator iter = this.segments.listIterator();
            while (iter.hasNext()) {
                Segment segment = (Segment)iter.next();
                Waypoint closest = segment.update(currentPosition);
                this.closestPoint.x = closest.x;
                this.closestPoint.y = closest.y;
                if (segment.isComplete()) {
                    iter.remove();
                    continue;
                }
                return segment.getPathError();
            }
            return 0.0;
        }

        private Waypoint getClosestPoint() {
            return this.closestPoint;
        }

        private double getRemainingDistance() {
            double distance = 0.0;
            ListIterator iter = this.segments.listIterator();
            while (iter.hasNext()) {
                distance += ((Segment)iter.next()).getRemainingLength();
            }
            return distance;
        }
    }
}

