/*
 * Decompiled with CFR 0.152.
 */
package org.tahomarobotics.robot.path;

import edu.wpi.first.wpilibj.command.Command;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PathActions {
    private final List<PathAction> pathActions = new ArrayList<PathAction>();
    private final List<PathAction> pendingPathActions = new ArrayList<PathAction>();
    private final List<PathAction> startedPathActions = new ArrayList<PathAction>();

    protected void setupPathActions(double startLength, double length, PathAction ... actions) {
        for (PathAction action : actions) {
            action.pathPositionStart = startLength + length * action.position;
            this.pathActions.add(action);
        }
    }

    public List<PathAction> getPathActions() {
        return this.pathActions;
    }

    public void resetPathActions() {
        this.pendingPathActions.clear();
        this.pendingPathActions.addAll(this.pathActions);
        this.startedPathActions.clear();
    }

    public void processPathActions(double pathPosition) {
        Iterator<PathAction> pendingIterator = this.pendingPathActions.iterator();
        while (pendingIterator.hasNext()) {
            PathAction pendingPathAction = pendingIterator.next();
            if (!(pathPosition >= pendingPathAction.pathPositionStart)) continue;
            pendingIterator.remove();
            pendingPathAction.command.start();
            if (!pendingPathAction.waitForCompletion) continue;
            this.startedPathActions.add(pendingPathAction);
        }
    }

    public boolean arePathActionsComplete() {
        for (PathAction pathAction : this.startedPathActions) {
            if (!pathAction.command.isRunning()) continue;
            return false;
        }
        return true;
    }

    public static class PathAction {
        public final Command command;
        public final double position;
        public final boolean waitForCompletion;
        private double pathPositionStart;

        public PathAction(Command action) {
            this(action, 1.0, true);
        }

        public PathAction(Command action, double position) {
            this(action, position, true);
        }

        public PathAction(Command action, boolean waitForCompletion) {
            this(action, 1.0, waitForCompletion);
        }

        public PathAction(Command command, double position, boolean waitForCompletion) {
            this.command = command;
            this.position = Math.min(Math.max(position, 0.0), 1.0);
            this.waitForCompletion = waitForCompletion;
        }
    }
}

