/*
 * Decompiled with CFR 0.152.
 */
package org.tahomarobotics.robot.path;

import java.util.ArrayList;
import java.util.List;
import org.tahomarobotics.robot.path.PathActions;
import org.tahomarobotics.robot.path.PathSection;
import org.tahomarobotics.robot.path.Waypoint;
import org.tahomarobotics.robot.state.Pose2D;
import org.tahomarobotics.robot.util.MathUtil;

public class PathBuilder {
    private static final double CURVE_SEG_SIZE = 5.0;
    private final Mirror mirror;
    private final PathDirection direction;
    private double totalLength;
    private final List<PathSection> sections = new ArrayList<PathSection>();
    private Pose2D startPose;
    private final PathActions pathActions = new PathActions();

    public PathBuilder(PathDirection direction, Mirror mirror, Pose2D initialPose) {
        this.direction = direction;
        this.mirror = mirror;
        this.startPose = PathBuilder.mirrorPose2D(initialPose, mirror);
        if (direction == PathDirection.Reversed) {
            this.startPose.heading += 180.0;
            this.startPose.heading = MathUtil.normalizeAngleDegrees(this.startPose.heading);
        }
    }

    public List<PathSection> getSections() {
        return this.sections;
    }

    public static Waypoint mirrorPoint(Waypoint waypoint, Mirror mirror) {
        Waypoint pt = new Waypoint(waypoint);
        switch (mirror) {
            case None: {
                break;
            }
            case X: {
                pt.x = 648.0 - pt.x;
                break;
            }
            case Y: {
                pt.y = 324.0 - pt.y;
                break;
            }
            case Both: {
                pt.x = 648.0 - pt.x;
                pt.y = 324.0 - pt.y;
            }
        }
        return pt;
    }

    public static double mirrorAngle(double angle, Mirror mirror) {
        switch (mirror) {
            case X: 
            case Y: {
                angle = -angle;
            }
        }
        return angle;
    }

    public static Pose2D mirrorPose2D(Pose2D pose, Mirror mirror) {
        double heading = pose.heading;
        if (mirror == Mirror.X || mirror == Mirror.Both) {
            heading = MathUtil.normalizeAngleDegrees(heading + 180.0);
        }
        Waypoint pt = PathBuilder.mirrorPoint(new Waypoint(pose.x, pose.y, 0.0), mirror);
        return new Pose2D(pt.x, pt.y, heading);
    }

    public void addLine(double length, double maxSpeed, PathActions.PathAction ... actions) {
        PathSection section = new PathSection(length, maxSpeed, this.startPose);
        this.startPose = section.endPose;
        this.sections.add(section);
        this.pathActions.setupPathActions(this.totalLength, length, actions);
        this.totalLength += length;
    }

    public void addArc(double angle, double radius, double maxSpeed, PathActions.PathAction ... actions) {
        PathSection section = new PathSection(PathBuilder.mirrorAngle(angle, this.mirror), radius, maxSpeed, this.startPose);
        this.startPose = section.endPose;
        this.sections.add(section);
        this.pathActions.setupPathActions(this.totalLength, section.length, actions);
        this.totalLength += section.length;
    }

    public void addArcToPoint(double x, double y, double maxSpeed, PathActions.PathAction ... actions) {
        Waypoint point = new Waypoint(x, y, maxSpeed);
        point = PathBuilder.mirrorPoint(point, this.mirror);
        double dist = point.distance(this.startPose.x, this.startPose.y);
        double angle = MathUtil.normalizeAngle(point.angle(this.startPose.x, this.startPose.y) - MathUtil.normalizeAngle(Math.toRadians(this.startPose.heading)));
        angle = PathBuilder.mirrorAngle(angle, this.mirror);
        double radius = Math.abs(dist / 2.0 / Math.sin(angle));
        this.addArc(2.0 * Math.toDegrees(angle), radius, maxSpeed, actions);
    }

    public Pose2D getFinalPose() {
        Pose2D pose2D = new Pose2D(this.startPose);
        if (this.direction == PathDirection.Reversed) {
            pose2D.reverse();
        }
        return PathBuilder.mirrorPose2D(pose2D, this.mirror);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (PathSection section : this.sections) {
            sb.append(section).append('\n');
        }
        return sb.toString();
    }

    public List<Waypoint> createWaypoints() {
        ArrayList<Waypoint> waypoints = new ArrayList<Waypoint>();
        Pose2D end = null;
        for (PathSection section : this.sections) {
            if (section.angle == 0.0) {
                waypoints.add(new Waypoint(section.startPose.x, section.startPose.y, section.maxVelocity));
            } else {
                int numSegments = (int)(Math.abs(section.angle) / 5.0) + 1;
                double deltaAngle = section.angle / (double)numSegments;
                double chord = 2.0 * section.radius * Math.sin(Math.toRadians(Math.abs(section.angle)) / 2.0 / (double)numSegments);
                Pose2D pose = new Pose2D(section.startPose);
                for (int i = 0; i < numSegments; ++i) {
                    waypoints.add(new Waypoint(pose.x, pose.y, section.maxVelocity));
                    double halfAngle = Math.toRadians(pose.heading + deltaAngle / 2.0);
                    pose.x += chord * Math.cos(halfAngle);
                    pose.y += chord * Math.sin(halfAngle);
                    pose.heading += deltaAngle;
                }
            }
            end = section.endPose;
        }
        waypoints.add(new Waypoint(end.x, end.y, 0.0));
        return waypoints;
    }

    public PathActions getPathActions() {
        return this.pathActions;
    }

    public static enum Mirror {
        None,
        X,
        Y,
        Both;

    }

    public static enum PathDirection {
        Forward(1.0),
        Reversed(-1.0);

        public final double sign;

        private PathDirection(double sign) {
            this.sign = sign;
        }
    }
}

