/*
 * Decompiled with CFR 0.152.
 */
package org.tahomarobotics.robot.path;

import org.tahomarobotics.robot.state.Pose2D;
import org.tahomarobotics.robot.util.MathUtil;

public class PathSection {
    public final double length;
    public final double angle;
    public final double radius;
    public final double maxVelocity;
    public double maxRotationalVelocity;
    public final Pose2D startPose;
    public final Pose2D endPose;

    public PathSection(double length, double maxVelocity, Pose2D startPose) {
        this.length = length;
        this.angle = 0.0;
        this.radius = 0.0;
        this.maxVelocity = maxVelocity;
        this.startPose = startPose;
        this.endPose = new Pose2D(startPose);
        double angleRadians = Math.toRadians(startPose.heading);
        this.endPose.x += length * Math.cos(angleRadians);
        this.endPose.y += length * Math.sin(angleRadians);
    }

    public PathSection(double angle, double radius, double maxVelocity, Pose2D startPose) {
        double angleRadians = MathUtil.normalizeAngle(Math.toRadians(angle));
        this.length = Math.abs(angleRadians) * radius;
        this.angle = angle;
        this.radius = radius;
        this.maxVelocity = maxVelocity;
        this.startPose = startPose;
        this.endPose = new Pose2D(startPose);
        double chord = 2.0 * radius * Math.sin(Math.abs(angleRadians) / 2.0);
        double halfAngle = Math.toRadians(startPose.heading) + angleRadians / 2.0;
        this.endPose.heading += angle;
        this.endPose.x += chord * Math.cos(halfAngle);
        this.endPose.y += chord * Math.sin(halfAngle);
    }

    public String toString() {
        return String.format("Section: %6.1f %6.1f %6.1f - start%s - end%s", this.length, this.angle, this.maxVelocity, this.startPose, this.endPose);
    }
}

