/*
 * Decompiled with CFR 0.152.
 */
package org.tahomarobotics.robot.path;

import java.util.ArrayList;
import java.util.List;
import org.tahomarobotics.robot.path.CompletionListener;
import org.tahomarobotics.robot.state.Pose2D;

public class Waypoint {
    private final List<CompletionListener> listeners = new ArrayList<CompletionListener>();
    public double x;
    public double y;
    public double speed;

    public Waypoint() {
    }

    public Waypoint(Waypoint src) {
        this.x = src.x;
        this.y = src.y;
        this.speed = src.speed;
    }

    public Waypoint(Pose2D src, double speed) {
        this.x = src.x;
        this.y = src.y;
        this.speed = speed;
    }

    public Waypoint(double x, double y, double speed) {
        this(x, y, speed, null);
    }

    public Waypoint(double x, double y, double speed, CompletionListener listener) {
        this.x = x;
        this.y = y;
        this.speed = speed;
        if (listener != null) {
            this.addCompletionListener(listener);
        }
    }

    public void addCompletionListener(CompletionListener listener) {
        this.listeners.add(listener);
    }

    protected void fireCaptureEvent() {
        for (CompletionListener listener : this.listeners) {
            listener.onCompletion();
        }
    }

    protected Waypoint mult(double a) {
        return new Waypoint(this.x * a, this.y * a, this.speed);
    }

    protected Waypoint add(Waypoint other) {
        return new Waypoint(this.x + other.x, this.y + other.y, this.speed);
    }

    protected Waypoint div(double a) {
        return new Waypoint(this.x / a, this.y / a, this.speed);
    }

    public double distance(Waypoint pt) {
        return this.distance(pt.x, pt.y);
    }

    public double distance(double x, double y) {
        double dx = x - this.x;
        double dy = y - this.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double angle(Waypoint pt) {
        return this.angle(pt.x, pt.y);
    }

    public double angle(double x, double y) {
        double dx = this.x - x;
        double dy = this.y - y;
        return Math.atan2(dy, dx);
    }

    public String toString() {
        return String.format("%6.3f %6.3f %6.3f", this.x, this.y, this.speed);
    }
}

