/*
 * Decompiled with CFR 0.152.
 */
package org.tahomarobotics.robot.state;

public class Pose2D {
    public double x;
    public double y;
    public double heading;

    public Pose2D() {
    }

    public Pose2D(double x, double y, double heading) {
        this.x = x;
        this.y = y;
        this.heading = heading;
    }

    public Pose2D(Pose2D pose) {
        this(pose.x, pose.y, pose.heading);
    }

    public Pose2D reverse() {
        this.heading += 180.0;
        this.heading = this.normalize(this.heading);
        return this;
    }

    private double normalize(double angle) {
        double newAngle;
        for (newAngle = angle; newAngle <= -180.0; newAngle += 360.0) {
        }
        while (newAngle > 180.0) {
            newAngle -= 360.0;
        }
        return newAngle;
    }

    public String toString() {
        return String.format("Pose: %6.2f %6.2f %6.2f", this.x, this.y, this.heading);
    }
}

