/*
 * Decompiled with CFR 0.152.
 */
package org.tahomarobotics.robot.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class ChartData {
    private final List<String> names = new ArrayList<String>();
    private final List<double[]> data = new ArrayList<double[]>();

    protected ChartData(List<String> names) {
        for (String name : names) {
            this.names.add(name);
        }
    }

    public ChartData(String title, String xaxis, String yaxis, String[] seriesNames) {
        this.names.add(title);
        this.names.add(xaxis);
        this.names.add(yaxis);
        for (String name : seriesNames) {
            this.names.add(name);
        }
    }

    public void addData(double[] data) {
        assert (data != null && data.length == this.names.size() - 2);
        this.data.add(data);
    }

    public void clear() {
        this.data.clear();
    }

    public byte[] serialize() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new SmileFactory());
        ObjectNode node = mapper.createObjectNode();
        node.putPOJO("names", this.names);
        node.putPOJO("data", this.data);
        try {
            mapper.writeValue((OutputStream)out, (Object)node);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out.toByteArray();
    }

    public static ChartData deserialize(byte[] json) {
        try {
            ObjectMapper mapper = new ObjectMapper((JsonFactory)new SmileFactory());
            JsonNode root = mapper.readTree(json);
            JsonNode namesNode = root.findValue("names");
            if (!namesNode.isMissingNode() && namesNode.isArray()) {
                ObjectReader reader = mapper.readerFor((TypeReference)new TypeReference<List<String>>(){});
                List list = (List)reader.readValue(namesNode);
                ChartData chartData = new ChartData(list);
                JsonNode dataNode = root.findValue("data");
                if (!dataNode.isMissingNode() && dataNode.isArray()) {
                    reader = mapper.readerFor((TypeReference)new TypeReference<List<double[]>>(){});
                    chartData.setData((List)reader.readValue(dataNode));
                    return chartData;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getTitle() {
        return this.names.get(0);
    }

    public String getXAxis() {
        return this.names.get(1);
    }

    public String getYAxis() {
        return this.names.get(2);
    }

    public int getSeriesCount() {
        return this.names.size() - 3;
    }

    public String getSeriesName(int i) {
        return this.names.get(3 + i);
    }

    public List<double[]> getData() {
        return this.data;
    }

    private void setData(List<double[]> data) {
        this.data.addAll(data);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Title: ").append(this.getTitle()).append('\n');
        sb.append("X-Axis: ").append(this.getXAxis()).append('\n');
        sb.append("Y-Axis: ").append(this.getYAxis()).append('\n');
        sb.append("Title: ").append(this.getTitle()).append('\n');
        sb.append("x ");
        for (int c = 0; c < this.getSeriesCount(); ++c) {
            sb.append(this.getSeriesName(c)).append(' ');
        }
        sb.append('\n');
        for (double[] r : this.getData()) {
            for (double d : r) {
                sb.append(d).append(' ');
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public static void main(String[] args) throws IOException {
        ChartData chartData = new ChartData("Lift Motion", "Time (sec)", "Velocity (deg/sec)", new String[]{"sin", "cos", "tan"});
        for (double x = 0.0; x < 10.0; x += 0.1) {
            double y = Math.cos(x);
            double z = Math.sin(x);
            double zz = Math.tan(x);
            chartData.addData(new double[]{x, y, z, zz});
        }
        for (int i = 0; i < 100; ++i) {
            long start = System.nanoTime();
            byte[] raw = chartData.serialize();
            long s = System.nanoTime();
            chartData = ChartData.deserialize(raw);
            long d = System.nanoTime();
            System.out.println("serialize: " + 1.0E-6 * (double)(s - start));
            System.out.println("deserialize: " + 1.0E-6 * (double)(d - s));
        }
    }
}

