/*
 * Decompiled with CFR 0.152.
 */
package org.tahomarobotics.robot.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class PathData {
    private final List<double[]> paths;

    public PathData() {
        this(new ArrayList<double[]>());
    }

    private PathData(List<double[]> paths) {
        this.paths = paths;
    }

    public void clearData() {
        this.paths.clear();
    }

    public void addPath(double[] points) {
        assert (points != null && points.length % 2 == 0);
        this.paths.add(points);
    }

    public List<double[]> getPaths() {
        return this.paths;
    }

    public byte[] serialize() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new SmileFactory());
        ObjectNode node = mapper.createObjectNode();
        node.putPOJO("paths", this.paths);
        try {
            mapper.writeValue((OutputStream)out, (Object)node);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out.toByteArray();
    }

    public static PathData deserialize(byte[] json) {
        try {
            ObjectMapper mapper = new ObjectMapper((JsonFactory)new SmileFactory());
            JsonNode root = mapper.readTree(json);
            JsonNode dataNode = root.findValue("paths");
            if (!dataNode.isMissingNode() && dataNode.isArray()) {
                ObjectReader reader = mapper.readerFor((TypeReference)new TypeReference<List<double[]>>(){});
                return new PathData((List)reader.readValue(dataNode));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

