/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.commons.connection.memory;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Node;
import org.pentaho.commons.connection.IMultiDimensionalResultSet;
import org.pentaho.commons.connection.IPeekable;
import org.pentaho.commons.connection.IPentahoMetaData;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.commons.connection.memory.MemoryMetaData;

public class MemoryResultSet
implements IPentahoResultSet,
IPeekable,
IMultiDimensionalResultSet {
    private IPentahoMetaData metaData;
    protected List<Object[]> rows;
    protected Iterator iterator = null;
    protected Object[] peekRow;
    protected int rowIndex = 0;

    public MemoryResultSet() {
        this.rows = new ArrayList<Object[]>();
    }

    public MemoryResultSet(IPentahoMetaData metaData) {
        this.metaData = metaData;
        this.rows = new ArrayList<Object[]>();
    }

    public void setMetaData(IPentahoMetaData metaData) {
        this.metaData = metaData;
        this.rows = new ArrayList<Object[]>();
    }

    public void setRows(List rows) {
        this.rows = rows;
        this.rowIndex = 0;
    }

    public List getRows() {
        return this.rows;
    }

    public int addRow(Object[] row) {
        this.rows.add(row);
        return this.rows.size() - 1;
    }

    @Override
    public IPentahoMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public Object[] peek() {
        if (this.peekRow == null) {
            this.peekRow = this.next();
        }
        return this.peekRow;
    }

    @Override
    public Object[] next() {
        if (this.peekRow != null) {
            Object[] row = this.peekRow;
            this.peekRow = null;
            return row;
        }
        if (this.iterator == null) {
            this.iterator = this.rows.iterator();
        }
        if (this.iterator.hasNext()) {
            ++this.rowIndex;
            return (Object[])this.iterator.next();
        }
        return null;
    }

    @Override
    public void close() {
        this.iterator = null;
        this.rowIndex = 0;
    }

    @Override
    public void closeConnection() {
        this.close();
    }

    @Override
    public void dispose() {
        this.close();
    }

    public static MemoryResultSet createFromArrays(Object[][] colHeads, Object[][] theRows) {
        MemoryMetaData metaData = new MemoryMetaData(colHeads, null);
        MemoryResultSet result = new MemoryResultSet(metaData);
        for (int i = 0; i < theRows.length; ++i) {
            result.addRow(theRows[i]);
        }
        return result;
    }

    public static MemoryResultSet createFromLists(List colHeaders, List data) {
        Object[][] columnHeaders = new String[1][colHeaders.size()];
        for (int i = 0; i < colHeaders.size(); ++i) {
            columnHeaders[0][i] = colHeaders.get(i);
        }
        MemoryMetaData metaData = new MemoryMetaData(columnHeaders, null);
        MemoryResultSet result = new MemoryResultSet(metaData);
        for (int i = 0; i < data.size(); ++i) {
            result.addRow(((List)data.get(i)).toArray());
        }
        return result;
    }

    public static MemoryResultSet createList(String name, List items) {
        Object[][] columnHeaders = new String[][]{{name}};
        MemoryMetaData metaData = new MemoryMetaData(columnHeaders, null);
        MemoryResultSet result = new MemoryResultSet(metaData);
        for (Object item : items) {
            Object[] row = new Object[]{item};
            result.addRow(row);
        }
        return result;
    }

    public static MemoryResultSet createFromActionSequenceInputsNode(Node rootNode) {
        List colHeaders = rootNode.selectNodes("columns/*");
        Object[][] columnHeaders = new String[1][colHeaders.size()];
        String[] columnTypes = new String[colHeaders.size()];
        for (int i = 0; i < colHeaders.size(); ++i) {
            Node theNode = (Node)colHeaders.get(i);
            columnHeaders[0][i] = theNode.getName();
            columnTypes[i] = MemoryResultSet.getNodeText("@type", theNode);
        }
        MemoryMetaData metaData = new MemoryMetaData(columnHeaders, null);
        metaData.setColumnTypes(columnTypes);
        MemoryResultSet result = new MemoryResultSet(metaData);
        List rowNodes = rootNode.selectNodes("default-value/row");
        for (int r = 0; r < rowNodes.size(); ++r) {
            Node theNode = (Node)rowNodes.get(r);
            Object[] theRow = new Object[columnHeaders[0].length];
            for (int c = 0; c < columnHeaders[0].length; ++c) {
                theRow[c] = MemoryResultSet.getNodeText(columnHeaders[0][c].toString(), theNode);
            }
            result.addRow(theRow);
        }
        return result;
    }

    public static String getNodeText(String xpath, Node rootNode) {
        return MemoryResultSet.getNodeText(xpath, rootNode, null);
    }

    public static String getNodeText(String xpath, Node rootNode, String defaultValue) {
        if (rootNode == null) {
            return defaultValue;
        }
        Node node = rootNode.selectSingleNode(xpath);
        if (node == null) {
            return defaultValue;
        }
        return node.getText();
    }

    @Override
    public boolean isScrollable() {
        return true;
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object[] theRow = this.rows.get(row);
        return theRow[column];
    }

    @Override
    public int getColumnCount() {
        return this.metaData.getColumnCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPentahoResultSet memoryCopy() {
        try {
            MemoryResultSet cachedResultSet = new MemoryResultSet(this.getMetaData());
            Object[] rowObjects = this.next();
            while (rowObjects != null) {
                cachedResultSet.addRow(rowObjects);
                rowObjects = this.next();
            }
            MemoryResultSet memoryResultSet = cachedResultSet;
            return memoryResultSet;
        }
        finally {
            this.close();
        }
    }

    @Override
    public void beforeFirst() {
        this.iterator = this.rows.iterator();
        this.rowIndex = 0;
    }

    @Override
    public Object[] getDataColumn(int column) {
        Object[] result = new Object[this.getRowCount()];
        int index = 0;
        Iterator<Object[]> iter = this.rows.iterator();
        while (iter.hasNext()) {
            result[index] = iter.next()[column];
            ++index;
        }
        return result;
    }

    @Override
    public Object[] getDataRow(int row) {
        if (row >= this.rows.size()) {
            return null;
        }
        return this.rows.get(row);
    }

    @Override
    public Object[] nextFlattened() {
        Object[][] rowHeaders = this.metaData.getRowHeaders();
        if (rowHeaders == null) {
            return this.next();
        }
        Object[] row = this.next();
        if (row == null) {
            return null;
        }
        if (this.rowIndex <= rowHeaders.length) {
            Object[] rowHeads = rowHeaders[this.rowIndex - 1];
            Object[] flatRow = new Object[rowHeads.length + row.length];
            System.arraycopy(rowHeads, 0, flatRow, 0, rowHeads.length);
            System.arraycopy(row, 0, flatRow, rowHeads.length, row.length);
            return flatRow;
        }
        return row;
    }

    @Override
    public Object[] peekFlattened() {
        Object[][] rowHeaders = this.metaData.getRowHeaders();
        if (rowHeaders == null) {
            return this.peek();
        }
        Object[] row = this.peek();
        if (row == null) {
            return null;
        }
        if (this.rowIndex <= rowHeaders.length) {
            Object[] rowHeads = rowHeaders[this.rowIndex - 1];
            Object[] flatRow = new Object[rowHeads.length + row.length];
            System.arraycopy(rowHeads, 0, flatRow, 0, rowHeads.length);
            System.arraycopy(row, 0, flatRow, rowHeads.length, row.length);
            return flatRow;
        }
        return row;
    }
}

