/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.datasource.derby;

import java.util.Dictionary;
import org.apache.derby.jdbc.ClientDataSource;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public class DataSourceConfigurator
implements ManagedService {
    private ClientDataSource dataSource;

    public void setDataSource(ClientDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void updated(Dictionary properties) throws ConfigurationException {
        if (properties == null) {
            return;
        }
        if (this.dataSource != null) {
            this.dataSource.setServerName(this.getString(properties, "datasource.server"));
            this.dataSource.setPortNumber(this.getInt(properties, "datasource.port"));
            this.dataSource.setDatabaseName(this.getString(properties, "datasource.database"));
            this.dataSource.setUser(this.getString(properties, "datasource.user"));
            this.dataSource.setPassword(this.getString(properties, "datasource.password"));
        }
    }

    private String getString(Dictionary properties, String key) {
        Object value = properties.get(key);
        return !(value instanceof String) ? "" : (String)value;
    }

    private int getInt(Dictionary properties, String key) {
        return Integer.parseInt(properties.get(key).toString());
    }
}

