/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.datasource.derby;

import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import org.apache.derby.jdbc.ClientConnectionPoolDataSource;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class ShutdownDBActivator
implements BundleActivator {
    public void start(BundleContext context) throws Exception {
    }

    public void stop(BundleContext context) throws Exception {
        ServiceReference serviceRef = context.getServiceReference(ConfigurationAdmin.class.getName());
        ConfigurationAdmin cfgAdmin = (ConfigurationAdmin)context.getService(serviceRef);
        Configuration config = cfgAdmin.getConfiguration("org.talend.esb.datasource.derby");
        String serverName = (String)config.getProperties().get("datasource.server");
        int portNumber = Integer.parseInt((String)config.getProperties().get("datasource.port"));
        String dbName = (String)config.getProperties().get("datasource.database");
        String user = (String)config.getProperties().get("datasource.username");
        String password = (String)config.getProperties().get("datasource.password");
        ClientConnectionPoolDataSource dataSource = new ClientConnectionPoolDataSource();
        dataSource.setServerName(serverName);
        dataSource.setPortNumber(portNumber);
        dataSource.setDatabaseName(dbName);
        dataSource.setShutdownDatabase("shutdown");
        dataSource.setUser(user);
        dataSource.setPassword(password);
        try {
            dataSource.getConnection();
        }
        catch (SQLException ex) {
            if (ex.getSQLState().equals("08006")) {
                return;
            }
            if (ex instanceof SQLNonTransientConnectionException) {
                return;
            }
            throw ex;
        }
    }
}

