/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.monitoring.hq;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.hq.product.ServiceResource;
import org.hyperic.hq.product.jmx.MxServerDetector;
import org.hyperic.util.config.ConfigResponse;
import org.talend.esb.monitoring.hq.HypericUtils;

public class DynamicMxFieldServerDetector
extends MxServerDetector {
    private final Log log = this.getLog();
    private Pattern dynamicFieldPattern = null;
    private String dynamicFieldName;
    private String targetFormat;
    private String title;

    public void init(PluginManager manager) throws PluginException {
        super.init(manager);
        this.title = HypericUtils.getMandatoryProperty((GenericPlugin)this, "server_title");
        String sDynField = HypericUtils.getOptionalProperty((GenericPlugin)this, "dynamic_field_pattern");
        if (sDynField != null && !"".equals(sDynField)) {
            this.dynamicFieldPattern = Pattern.compile(sDynField);
            this.dynamicFieldName = HypericUtils.getMandatoryProperty((GenericPlugin)this, "dynamic_field_name");
            this.targetFormat = HypericUtils.getMandatoryProperty((GenericPlugin)this, "target_format");
        }
    }

    protected List discoverServices(ConfigResponse serverConfig) throws PluginException {
        HypericUtils.logInfo(this.log, "Starting discovery of ", this.title, " services.");
        List services = super.discoverServices(serverConfig);
        if (this.dynamicFieldPattern == null) {
            return services;
        }
        for (Object obj : services) {
            if (obj instanceof ServiceResource) {
                ServiceResource service = (ServiceResource)obj;
                ConfigResponse config = service.getProductConfig();
                String dfValue = config.getValue(this.dynamicFieldName);
                Matcher m = this.dynamicFieldPattern.matcher(dfValue);
                if (m.matches() && m.groupCount() > 0) {
                    String constantFieldValue = m.group(1);
                    config.setValue(this.dynamicFieldName, constantFieldValue);
                    String formatedFieldValue = this.formatFieldValue(this.targetFormat, constantFieldValue);
                    String name = this.formatAutoInventoryName(service.getType(), serverConfig, config, null);
                    config.setValue(this.dynamicFieldName, formatedFieldValue);
                    service.setName(name);
                    service.setProductConfig(config);
                    HypericUtils.logInfo(this.log, "Found dynamic field value '", dfValue, "', converted it into '", formatedFieldValue, "'.");
                    continue;
                }
                HypericUtils.logInfo(this.log, "Found static field value '", dfValue, "'.");
                continue;
            }
            this.log.fatal((Object)("Unexpected object of class " + obj.getClass().getName()));
        }
        HypericUtils.logInfo(this.log, "Discovery of ", this.title, " services has finished. ", services.size(), " service(s) found.");
        return services;
    }

    protected String formatFieldValue(String targetFormat, String fieldValue) {
        return targetFormat.replace("{}", fieldValue);
    }
}

