/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.monitoring.hq;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import org.apache.commons.logging.Log;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.jmx.MxUtil;
import org.hyperic.util.config.ConfigResponse;
import org.talend.esb.monitoring.hq.DynamicMxFieldServerDetector;
import org.talend.esb.monitoring.hq.HypericUtils;

public abstract class AbstractEmbeddedServerDetector
extends DynamicMxFieldServerDetector {
    protected final Log log = this.getLog();
    protected ObjectName targetDomainPattern;
    protected ObjectName absentDomainPattern;
    protected String title;

    public void init(PluginManager manager) throws PluginException {
        super.init(manager);
        this.title = HypericUtils.getMandatoryProperty((GenericPlugin)this, "server_title");
        try {
            this.targetDomainPattern = new ObjectName(HypericUtils.getMandatoryProperty((GenericPlugin)this, "target_domain") + ":*");
        }
        catch (MalformedObjectNameException e) {
            throw new PluginException((Throwable)e);
        }
        try {
            String objName = HypericUtils.getOptionalProperty((GenericPlugin)this, "absent_domain");
            if (objName != null) {
                this.absentDomainPattern = new ObjectName(objName + ":*");
            }
        }
        catch (MalformedObjectNameException e) {
            throw new PluginException((Throwable)e);
        }
    }

    protected File findVersionFile(File dir, Pattern pattern) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("This is not a directory: " + dir.getAbsolutePath());
        }
        File[] fileList = dir.listFiles();
        if (fileList == null) {
            return null;
        }
        HashSet<File> subs = new HashSet<File>();
        for (File file : fileList) {
            if (file.isDirectory()) {
                subs.add(file);
                continue;
            }
            if (!this.versionFileMatches(file.getAbsolutePath(), pattern)) continue;
            return file;
        }
        for (File subDir : subs) {
            File versionFile = this.findVersionFile(subDir, pattern);
            if (versionFile == null) continue;
            return versionFile;
        }
        return null;
    }

    protected boolean versionFileMatches(String fileName, Pattern pattern) {
        Matcher m = pattern.matcher(fileName);
        return m.find() && m.groupCount() > 0 && this.getTypeInfo().getVersion().equals(m.group(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getServerResources(ConfigResponse platformConfig) throws PluginException {
        List discoveredServers = super.getServerResources(platformConfig);
        ArrayList<ServerResource> serversToReturn = new ArrayList<ServerResource>();
        for (ServerResource serverRes : discoveredServers) {
            JMXConnector jmxConnector = null;
            try {
                jmxConnector = MxUtil.getMBeanConnector((Properties)serverRes.getProductConfig().toProperties());
                Set<ObjectName> objNames = jmxConnector.getMBeanServerConnection().queryNames(this.targetDomainPattern, null);
                if (objNames.size() <= 0 || this.absentDomainPattern != null && (objNames = jmxConnector.getMBeanServerConnection().queryNames(this.absentDomainPattern, null)).size() > 0) continue;
                StringBuilder sb = new StringBuilder();
                sb.append(this.title);
                sb.append("at");
                sb.append(serverRes.getInstallPath());
                serverRes.setIdentifier(sb.toString());
                serversToReturn.add(serverRes);
            }
            catch (IOException e) {
                this.log.debug((Object)("Unable to check whether destination MBeanServer contains domain " + this.targetDomainPattern.toString()), (Throwable)e);
            }
            finally {
                try {
                    if (jmxConnector == null) continue;
                    jmxConnector.close();
                }
                catch (IOException e) {
                    this.log.debug((Object)"Exception during closing the connection to MBeanServer.", (Throwable)e);
                }
            }
        }
        return serversToReturn;
    }
}

