/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.monitoring.hq;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.talend.esb.monitoring.hq.AbstractEmbeddedServerDetector;

public class TomcatEmbeddedServerDetector
extends AbstractEmbeddedServerDetector {
    private static final String WEBINF_LIB = "WEB-INF" + File.separator + "lib";

    protected File findVersionFile(File dir, Pattern pattern) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("This is not a directory: " + dir.getAbsolutePath());
        }
        File tomcatLibResult = this.searchInDir(new File(dir, "lib"), pattern);
        if (tomcatLibResult != null) {
            return tomcatLibResult;
        }
        File tomcatWebapps = new File(dir, "webapps");
        if (tomcatWebapps.isDirectory()) {
            File[] files = tomcatWebapps.listFiles();
            if (files == null) {
                return null;
            }
            for (File webapp : files) {
                File result;
                if (!(webapp.isDirectory() ? (result = this.searchInDir(new File(webapp, WEBINF_LIB), pattern)) != null : webapp.getName().endsWith(".war") && (result = this.searchInWarFile(webapp, pattern)) != null)) continue;
                return result;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File searchInWarFile(File warFile, Pattern pattern) {
        ZipFile file = null;
        try {
            file = new ZipFile(warFile);
            Enumeration<? extends ZipEntry> fileContent = file.entries();
            while (fileContent.hasMoreElements()) {
                String fn = fileContent.nextElement().getName();
                if (!this.versionFileMatches(fn, pattern)) continue;
                File file2 = new File(warFile + "!" + fn);
                return file2;
            }
        }
        catch (IOException e) {
            this.log.debug((Object)("Unable to check file '" + warFile + "'."), (Throwable)e);
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException e) {
                    this.log.debug((Object)("Unable to close file '" + warFile + "'."), (Throwable)e);
                }
            }
        }
        return null;
    }

    protected File searchInDir(File libDir, Pattern pattern) {
        File result;
        if (libDir.isDirectory() && (result = super.findVersionFile(libDir, pattern)) != null) {
            return result;
        }
        return null;
    }
}

