/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.monitoring.hq;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import org.apache.commons.logging.Log;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricInvalidException;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.hq.product.jmx.MxMeasurementPlugin;
import org.hyperic.hq.product.jmx.MxUtil;
import org.talend.esb.monitoring.hq.HypericUtils;

public class DynamicMxFieldMeasurementPlugin
extends MxMeasurementPlugin {
    private final Log log = this.getLog();
    private static final AtomicBoolean isFirstInstance = new AtomicBoolean(true);
    private static final int DEFAULT_GC_INTERVAL = 86400000;
    private static final String MSG_ERR_CONNECT = "Cannot find the new MBean name because of the connection problems.";
    private static final String MSG_ERR_NOTFOUND = "ObjectName has not been found.";
    private static final String MSG_ERR_MALFORMED = "Provided name has wrong format.";
    private static final String MSG_ERR_UNEXPECTED = "Unexpected problem during looking up an ObjectName.";
    private String targetDomain;
    private final TrivialCache cache = new TrivialCache();

    public void init(PluginManager manager) throws PluginException {
        super.init(manager);
        this.targetDomain = HypericUtils.getMandatoryProperty((GenericPlugin)this, "target_domain") + ":";
        boolean firstInstance = isFirstInstance.getAndSet(false);
        String gcIntervalStr = HypericUtils.getOptionalProperty((GenericPlugin)this, "gc_interval");
        if (gcIntervalStr == null) {
            this.logInfoOnlyFirstInstance(firstInstance, "No explicit cache periodical cleanup interval specified, scheduling it to happen every ", 86400000, " ms by default.");
            this.cache.scheduleGc(86400000L);
        } else {
            try {
                long interval = Long.valueOf(gcIntervalStr);
                if (interval > 0L) {
                    this.logInfoOnlyFirstInstance(firstInstance, "Scheduling cache periodical cleanup to happen every ", interval, " ms.");
                    this.cache.scheduleGc(interval);
                } else {
                    this.logInfoOnlyFirstInstance(firstInstance, "Cache periodical cleanup is switched off.", new Object[0]);
                }
            }
            catch (NumberFormatException e) {
                throw new PluginException("Cannot read cache gc interval value.", (Throwable)e);
            }
        }
    }

    public void shutdown() throws PluginException {
        super.shutdown();
        this.cache.clear();
    }

    private String findObjectName(String patternObjectName, Properties connectionProps) throws MetricNotFoundException, MetricUnreachableException, MetricInvalidException, PluginException {
        ObjectName patternOn;
        try {
            patternOn = new ObjectName(patternObjectName);
        }
        catch (MalformedObjectNameException e) {
            throw new MetricInvalidException(MSG_ERR_MALFORMED, (Throwable)e);
        }
        JMXConnector jmxConnector = null;
        try {
            jmxConnector = MxUtil.getCachedMBeanConnector((Properties)connectionProps);
            MBeanServerConnection conn = jmxConnector.getMBeanServerConnection();
            Set<ObjectName> result = conn.queryNames(patternOn, null);
            if (result.iterator().hasNext()) {
                String string = result.iterator().next().getCanonicalName();
                return string;
            }
        }
        catch (IOException e) {
            this.log.debug((Object)MSG_ERR_CONNECT, (Throwable)e);
            throw new MetricUnreachableException(MSG_ERR_CONNECT, (Throwable)e);
        }
        catch (Exception e) {
            this.log.debug((Object)MSG_ERR_UNEXPECTED, (Throwable)e);
            throw new PluginException(MSG_ERR_UNEXPECTED, (Throwable)e);
        }
        finally {
            MxUtil.close((JMXConnector)jmxConnector);
        }
        throw new MetricNotFoundException(MSG_ERR_NOTFOUND);
    }

    /*
     * Exception decompiling
     */
    public MetricValue getValue(Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException, MetricInvalidException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void logInfo(Object o1, Object ... info) {
        if (!this.log.isInfoEnabled()) {
            return;
        }
        if (info.length == 0) {
            this.log.info((Object)o1.toString());
            return;
        }
        StringBuilder sb = new StringBuilder(o1.toString());
        for (Object o : info) {
            sb.append(o.toString());
        }
        this.log.info((Object)sb.toString());
    }

    private void logInfoOnlyFirstInstance(boolean firstInstance, Object o1, Object ... info) {
        if (firstInstance) {
            this.logInfo(o1, info);
        }
    }

    static final class TrivialCache {
        private volatile Map<String, Entry> store = new HashMap<String, Entry>();
        private final Object lock = new Object();
        private final Timer gcTimer = new Timer();

        TrivialCache() {
        }

        public void shutdown() {
            this.gcTimer.cancel();
            this.gcTimer.purge();
            this.store.clear();
            this.store = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String get(String key) {
            Entry result = this.store.get(key);
            if (result == null) {
                return null;
            }
            if (result.outdated) {
                Object object = this.lock;
                synchronized (object) {
                    result.outdated = false;
                }
            }
            return result.value;
        }

        public boolean contains(String key) throws NullPointerException {
            if (key == null) {
                throw new NullPointerException("A key cannot be null.");
            }
            return this.store.containsKey(key);
        }

        public int size() {
            return this.store.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(String key, String value) {
            Object object = this.lock;
            synchronized (object) {
                this.store.put(key, new Entry(value, false));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invalidate(String key) {
            Object object = this.lock;
            synchronized (object) {
                this.store.remove(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.lock;
            synchronized (object) {
                this.store.clear();
            }
        }

        public void scheduleGc(long period) {
            this.gcTimer.schedule((TimerTask)new GcTask(), period, period);
        }

        void stopGc() {
            this.gcTimer.cancel();
        }

        private static class Entry {
            final String value;
            volatile boolean outdated;

            public Entry(String value, boolean outdated) {
                this.value = value;
                this.outdated = outdated;
            }
        }

        private class GcTask
        extends TimerTask {
            private GcTask() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                HashMap<String, Entry> newStore = new HashMap<String, Entry>();
                Object object = TrivialCache.this.lock;
                synchronized (object) {
                    if (TrivialCache.this.store.isEmpty()) {
                        return;
                    }
                    for (String key : TrivialCache.this.store.keySet()) {
                        Entry entry = (Entry)TrivialCache.this.store.get(key);
                        if (entry.outdated) continue;
                        newStore.put(key, new Entry(entry.value, true));
                    }
                    Map oldStore = TrivialCache.this.store;
                    TrivialCache.this.store = newStore;
                    oldStore.clear();
                }
            }
        }
    }
}

