/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.monitoring.hq;

import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.management.remote.JMXConnector;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.hq.product.jmx.MxMeasurementPlugin;
import org.hyperic.hq.product.jmx.MxUtil;
import org.talend.esb.monitoring.hq.HypericUtils;

public class KarafOSGiMeasurementPlugin
extends MxMeasurementPlugin {
    public static final String EXPIRATION_TIMEOUT = "expiration.timeout";
    public static final String PROP_BUNDLES_OBJNAME = "KARAF_BUNDLES_OBJECT_NAME";
    public static final String PROP_FEATURES_OBJNAME = "KARAF_FEATURES_OBJECT_NAME";
    public static final String PROP_SERVICES_OBJNAME = "KARAF_SERVICES_OBJECT_NAME";
    private final ConcurrentHashMap<String, MetricValue> dataCache = new ConcurrentHashMap(20);
    private long lastCollectionTime = 0L;
    private long expirationTimeout = 60000L;
    private ObjectName objnameBundles;
    private ObjectName objnameFeatures;
    private ObjectName objnameServices;

    public void init(PluginManager manager) throws PluginException {
        super.init(manager);
        try {
            this.expirationTimeout = Long.valueOf(HypericUtils.getMandatoryProperty((GenericPlugin)this, (String)EXPIRATION_TIMEOUT));
        }
        catch (NumberFormatException e) {
            throw new PluginException((Throwable)e);
        }
        try {
            this.objnameBundles = ObjectName.getInstance(HypericUtils.getMandatoryProperty((GenericPlugin)this, (String)PROP_BUNDLES_OBJNAME));
        }
        catch (PluginException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PluginException((Throwable)e);
        }
        try {
            this.objnameFeatures = ObjectName.getInstance(HypericUtils.getMandatoryProperty((GenericPlugin)this, (String)PROP_FEATURES_OBJNAME));
        }
        catch (PluginException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PluginException((Throwable)e);
        }
        try {
            this.objnameServices = ObjectName.getInstance(HypericUtils.getMandatoryProperty((GenericPlugin)this, (String)PROP_SERVICES_OBJNAME));
        }
        catch (PluginException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PluginException((Throwable)e);
        }
    }

    private TabularData retreiveTabularAttributeData(MBeanServerConnection connection, ObjectName objName, String attributeName) throws MetricUnreachableException, MetricNotFoundException {
        try {
            return (TabularData)TabularData.class.cast(connection.getAttribute(objName, attributeName));
        }
        catch (IOException e) {
            throw new MetricUnreachableException("Unable to get attribute value for " + objName + ":" + attributeName, (Throwable)e);
        }
        catch (Exception e) {
            throw new MetricNotFoundException("Unable to get attribute value for " + objName + ":" + attributeName, (Throwable)e);
        }
    }

    private TabularData retreiveTabularMethodData(MBeanServerConnection connection, ObjectName objName, String operationName) throws MetricUnreachableException, MetricNotFoundException {
        try {
            return (TabularData)TabularData.class.cast(connection.invoke(objName, operationName, null, null));
        }
        catch (IOException e) {
            throw new MetricUnreachableException("Unable to get operation return value for " + objName + "->" + operationName, (Throwable)e);
        }
        catch (Exception e) {
            throw new MetricNotFoundException("Unable to get operation return value for " + objName + "->" + operationName, (Throwable)e);
        }
    }

    private void updateBundlesData(MBeanServerConnection connection) throws MetricUnreachableException, MetricNotFoundException {
        TabularData td = this.retreiveTabularMethodData(connection, this.objnameBundles, "list");
        long bundlesTotal = td.size();
        long bundlesActive = 0L;
        long bundlesResolved = 0L;
        long bundlesInstalled = 0L;
        for (Object k : td.values()) {
            if (!(k instanceof CompositeData)) {
                throw new IllegalArgumentException();
            }
            CompositeData cdata = (CompositeData)k;
            if (!cdata.containsKey("State")) {
                throw new IllegalArgumentException();
            }
            String state = (String)cdata.get("State");
            if (state.startsWith("A") || state.startsWith("a")) {
                ++bundlesActive;
                continue;
            }
            if (state.startsWith("R") || state.startsWith("r")) {
                ++bundlesResolved;
                continue;
            }
            if (!state.startsWith("I") && !state.startsWith("i")) continue;
            ++bundlesInstalled;
        }
        this.dataCache.put("#Bundles-Total", new MetricValue(bundlesTotal));
        this.dataCache.put("#Bundles-Active", new MetricValue(bundlesActive));
        this.dataCache.put("#Bundles-Resolved", new MetricValue(bundlesResolved));
        this.dataCache.put("#Bundles-Installed", new MetricValue(bundlesInstalled));
    }

    private void updateFeaturesData(MBeanServerConnection connection) throws MetricUnreachableException, MetricNotFoundException {
        TabularData tdFeatures = this.retreiveTabularAttributeData(connection, this.objnameFeatures, "Features");
        long featuresTotal = tdFeatures.size();
        TabularData tdRepos = this.retreiveTabularAttributeData(connection, this.objnameFeatures, "Repositories");
        long repositoriesTotal = tdRepos.size();
        this.dataCache.put("#Features", new MetricValue(featuresTotal));
        this.dataCache.put("#FeatureRepositories", new MetricValue(repositoriesTotal));
    }

    private void updateServicesData(MBeanServerConnection connection) throws MetricUnreachableException, MetricNotFoundException {
        TabularData td = this.retreiveTabularMethodData(connection, this.objnameServices, "list");
        long servicesTotal = td.size();
        this.dataCache.put("#Services", new MetricValue(servicesTotal));
    }

    private synchronized void updateCache(Properties connectionProps) throws MetricUnreachableException, PluginException {
        if (System.currentTimeMillis() - this.lastCollectionTime < this.expirationTimeout) {
            return;
        }
        JMXConnector jmxConnector = null;
        try {
            jmxConnector = MxUtil.getCachedMBeanConnector((Properties)connectionProps);
            MBeanServerConnection conn = jmxConnector.getMBeanServerConnection();
            this.updateBundlesData(conn);
            this.updateFeaturesData(conn);
            this.updateServicesData(conn);
        }
        catch (IOException e) {
            throw new MetricUnreachableException("Error during communication with remote MBean Server.", (Throwable)e);
        }
        catch (Exception e) {
            throw new PluginException("", (Throwable)e);
        }
        finally {
            MxUtil.close((JMXConnector)jmxConnector);
        }
        this.lastCollectionTime = System.currentTimeMillis();
    }

    public MetricValue getValue(Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException {
        if (metric.isAvail()) {
            return super.getValue(metric);
        }
        this.updateCache(metric.getProperties());
        if (!this.dataCache.containsKey(metric.getAttributeName())) {
            throw new PluginException("Unknown metric " + metric.toString());
        }
        return this.dataCache.get(metric.getAttributeName());
    }
}

