/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.monitoring.hq;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricInvalidException;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.jmx.MxMeasurementPlugin;
import org.hyperic.hq.product.jmx.MxUtil;

public class JobServerMeasurementPlugin
extends MxMeasurementPlugin {
    public MetricValue getValue(Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException {
        if (metric.isAvail()) {
            return super.getValue(metric);
        }
        try {
            String objNameStr = Metric.decode((String)metric.getObjectName());
            Object o = MxUtil.getValue((Properties)metric.getProperties(), (String)objNameStr, (String)metric.getAttributeName());
            if (o instanceof Collection) {
                Collection c = (Collection)o;
                return new MetricValue((long)c.size());
            }
            if (o instanceof Map) {
                Map m = (Map)o;
                return new MetricValue((long)m.size());
            }
            if (o instanceof Number) {
                Number n = (Number)o;
                return new MetricValue(n);
            }
        }
        catch (IOException e) {
            throw new MetricUnreachableException("Error during communication with remote MBean Server.", (Throwable)e);
        }
        catch (Exception e) {
            throw new PluginException((Throwable)e);
        }
        throw new MetricInvalidException("Cannot parse value of metric " + metric.toString());
    }
}

