/*
 * #%L
 * Talend :: ESB :: Job :: API
 * %%
 * Copyright (C) 2011 Talend Inc.
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
package routines.system.api;

/**
 * Consumer interface for handling calls
 * from ESB Job towards other ESB services
 */
public interface ESBConsumer {

    /**
     * A blocking method to invoke a service inside of the Job
     *
     * @param request Payload of request
     * @return Payload of response
     * @throws Exception In case something goes wrong
     */
    public Object invoke(Object payload) throws Exception;

}
