/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.job.console;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class DeployServlet
extends HttpServlet {
    private BundleContext bundleContext;
    private File tmpDir;
    private File deployDir;

    public void init(ServletConfig servletConfig) throws ServletException {
        ServletContext context = servletConfig.getServletContext();
        this.bundleContext = (BundleContext)context.getAttribute("osgi-bundlecontext");
        this.tmpDir = new File(System.getProperty("java.io.tmpdir"));
        this.deployDir = new File(System.getProperty("karaf.base") + "/deploy");
        if (!this.deployDir.exists()) {
            this.deployDir.mkdirs();
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doIt(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doIt(request, response);
    }

    public void doIt(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        DiskFileItemFactory fileItemFactory = new DiskFileItemFactory();
        fileItemFactory.setSizeThreshold(0x100000);
        fileItemFactory.setRepository(this.tmpDir);
        ServletFileUpload uploadHandler = new ServletFileUpload((FileItemFactory)fileItemFactory);
        try {
            List items = uploadHandler.parseRequest(request);
            for (FileItem item : items) {
                if (item.isFormField()) continue;
                File file = new File(this.deployDir, item.getName());
                item.write(file);
                Bundle bundle = this.bundleContext.installBundle("file://" + file.getAbsolutePath());
                bundle.start();
            }
        }
        catch (Exception e) {
            response.sendRedirect("home.do?error=" + e.getMessage());
            return;
        }
        response.sendRedirect("home.do");
    }
}

