/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.job.controller.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.talend.esb.job.controller.Controller;
import org.talend.esb.job.controller.internal.TalendJobLauncher;
import routines.system.api.TalendJob;

public class ControllerImpl
implements Controller,
ServiceListener {
    private BundleContext bundleContext;
    private TalendJobLauncher talendJobLauncher;

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.bundleContext.addServiceListener((ServiceListener)this);
    }

    public void setLauncher(TalendJobLauncher talendJobLauncher) {
        this.talendJobLauncher = talendJobLauncher;
    }

    @Override
    public Map<String, List<String>> list() throws Exception {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("jobs", this.listJobs());
        map.put("routes", this.listRoutes());
        return map;
    }

    @Override
    public List<String> listJobs() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        ServiceReference[] references = this.bundleContext.getServiceReferences(TalendJob.class.getName(), "(!(type=route))");
        if (references != null) {
            for (ServiceReference reference : references) {
                String name;
                if (reference == null || (name = (String)reference.getProperty("name")) == null) continue;
                list.add(name);
            }
        }
        return list;
    }

    @Override
    public List<String> listRoutes() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        ServiceReference[] references = this.bundleContext.getServiceReferences(TalendJob.class.getName(), "(type=route)");
        if (references != null) {
            for (ServiceReference reference : references) {
                String name;
                if (reference == null || (name = (String)reference.getProperty("name")) == null) continue;
                list.add(name);
            }
        }
        return list;
    }

    @Override
    public void run(String name) throws Exception {
        this.run(name, new String[0]);
    }

    @Override
    public void run(String name, String[] args) throws Exception {
        ServiceReference[] references = this.bundleContext.getServiceReferences(TalendJob.class.getName(), "(name=" + name + ")");
        if (references == null) {
            throw new IllegalArgumentException("Talend job " + name + " not found");
        }
        TalendJob job = (TalendJob)this.bundleContext.getService(references[0]);
        if (job != null) {
            this.talendJobLauncher.runTalendJob(job, args);
        }
    }

    public void serviceChanged(ServiceEvent event) {
        String type;
        if (event.getType() == 4 && (type = (String)event.getServiceReference().getProperty("type")) != null && type.equalsIgnoreCase("job")) {
            TalendJob talendJob = (TalendJob)this.bundleContext.getService(event.getServiceReference());
            this.talendJobLauncher.stopTalendJob(talendJob);
        }
    }
}

