/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.job.controller.internal;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import javax.xml.ws.Provider;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceProvider;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.Soap12;
import org.apache.cxf.binding.soap.model.SoapBindingInfo;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.tools.common.extensions.soap.SoapOperation;
import org.apache.cxf.tools.util.SOAPBindingUtil;
import org.apache.cxf.wsdl.WSDLManager;
import org.dom4j.Document;
import org.dom4j.io.DocumentResult;
import org.dom4j.io.DocumentSource;
import org.talend.esb.job.controller.internal.RuntimeESBProviderCallback;

@ServiceMode(value=Service.Mode.PAYLOAD)
@WebServiceProvider
class ESBProvider
implements Provider<Source> {
    private static final Logger LOG = Logger.getLogger(ESBProvider.class.getName());
    private static final TransformerFactory factory = TransformerFactory.newInstance();
    private static final QName XSD_ANY_TYPE = new QName("http://www.w3.org/2001/XMLSchema", "anyType");
    private final Map<String, RuntimeESBProviderCallback> callbacks = new ConcurrentHashMap<String, RuntimeESBProviderCallback>();
    private final String publishedEndpointUrl;
    private final QName serviceName;
    private final QName portName;
    private final AbstractFeature serviceLocator;
    private final AbstractFeature serviceActivityMonitoring;
    private Server server;
    @Resource
    private WebServiceContext context;

    public ESBProvider(String publishedEndpointUrl, QName serviceName, QName portName, AbstractFeature serviceLocator, AbstractFeature serviceActivityMonitoring) {
        this.publishedEndpointUrl = publishedEndpointUrl;
        this.serviceName = serviceName;
        this.portName = portName;
        this.serviceLocator = serviceLocator;
        this.serviceActivityMonitoring = serviceActivityMonitoring;
    }

    public String getPublishedEndpointUrl() {
        return this.publishedEndpointUrl;
    }

    public void run(Bus bus) {
        JaxWsServerFactoryBean sf = new JaxWsServerFactoryBean();
        sf.setServiceName(this.serviceName);
        sf.setEndpointName(this.portName);
        sf.setAddress(this.publishedEndpointUrl);
        sf.setServiceBean((Object)this);
        ArrayList<AbstractFeature> features = new ArrayList<AbstractFeature>();
        if (this.serviceLocator != null) {
            features.add(this.serviceLocator);
        }
        if (this.serviceActivityMonitoring != null) {
            features.add(this.serviceActivityMonitoring);
        }
        sf.setFeatures(features);
        sf.setBus(bus);
        this.server = sf.create();
        this.removeOperation("invoke");
        InterfaceInfo ii = ((ServiceInfo)this.server.getEndpoint().getService().getServiceInfos().get(0)).getInterface();
        ii.setName(this.serviceName);
        LOG.info("Web service '" + this.serviceName + "' published at endpoint '" + this.publishedEndpointUrl + "'");
    }

    public Source invoke(Source request) {
        QName operationQName = (QName)this.context.getMessageContext().get((Object)"javax.xml.ws.wsdl.operation");
        LOG.info("Invoke operation '" + operationQName + "' for service '" + this.serviceName + "'");
        RuntimeESBProviderCallback esbProviderCallback = this.getESBProviderCallback(operationQName.getLocalPart());
        if (esbProviderCallback == null) {
            throw new RuntimeException("Handler for operation " + operationQName + " cannot be found");
        }
        try {
            DocumentResult docResult = new DocumentResult();
            factory.newTransformer().transform(request, (Result)docResult);
            Document requestDoc = docResult.getDocument();
            Object result = esbProviderCallback.invoke(requestDoc);
            if (result == null) {
                return null;
            }
            if (result instanceof Document) {
                return new DocumentSource((Document)result);
            }
            if (result instanceof RuntimeException) {
                throw (RuntimeException)result;
            }
            if (result instanceof Throwable) {
                throw new RuntimeException((Throwable)result);
            }
            throw new RuntimeException("Provider return incompatible object: " + result.getClass().getName());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public RuntimeESBProviderCallback createESBProviderCallback(String operationName, boolean isRequestResponse) {
        if (this.callbacks.get(operationName) != null) {
            throw new RuntimeException("Operation '" + operationName + "' for endpoint '" + this.publishedEndpointUrl + "' already registered");
        }
        RuntimeESBProviderCallback esbProviderCallback = new RuntimeESBProviderCallback(isRequestResponse);
        this.callbacks.put(operationName, esbProviderCallback);
        this.addOperation(operationName, isRequestResponse);
        return esbProviderCallback;
    }

    public RuntimeESBProviderCallback getESBProviderCallback(String operationName) {
        return this.callbacks.get(operationName);
    }

    public boolean destroyESBProviderCallback(String operationName) {
        this.callbacks.remove(operationName);
        if (this.callbacks.isEmpty()) {
            LOG.info("Web service '" + this.serviceName + "' stopped");
            this.server.destroy();
            return true;
        }
        this.removeOperation(operationName);
        return false;
    }

    private void addOperation(String operationName, boolean isRequestResponse) {
        ESBProvider.addOperation((ServiceInfo)this.server.getEndpoint().getService().getServiceInfos().get(0), operationName, isRequestResponse);
    }

    public static void addOperation(ServiceInfo si, String operationName, boolean isRequestResponse) {
        InterfaceInfo ii = si.getInterface();
        String namespace = ii.getName().getNamespaceURI();
        OperationInfo oi = ii.addOperation(new QName(namespace, operationName));
        MessageInfo mii = oi.createMessage(new QName(namespace, operationName + "Request"), MessageInfo.Type.INPUT);
        oi.setInput(operationName + "Request", mii);
        MessagePartInfo mpi = mii.addMessagePart("request");
        mpi.setTypeQName(XSD_ANY_TYPE);
        if (isRequestResponse) {
            MessageInfo mio = oi.createMessage(new QName(namespace, operationName + "Response"), MessageInfo.Type.OUTPUT);
            oi.setOutput(operationName + "Response", mio);
            mpi = mio.addMessagePart("response");
            mpi.setTypeQName(XSD_ANY_TYPE);
        }
        BindingInfo bi = (BindingInfo)si.getBindings().iterator().next();
        BindingOperationInfo boi = new BindingOperationInfo(bi, oi);
        bi.addOperation(boi);
        if (bi instanceof SoapBindingInfo) {
            SoapBindingInfo sbi = (SoapBindingInfo)bi;
            Bus bs = SpringBusFactory.getDefaultBus();
            WSDLManager m = (WSDLManager)bs.getExtension(WSDLManager.class);
            ExtensionRegistry extensionRegistry = m.getExtensionRegistry();
            boolean isSoap12 = sbi.getSoapVersion() instanceof Soap12;
            try {
                SoapOperation soapOperation = SOAPBindingUtil.createSoapOperation((ExtensionRegistry)extensionRegistry, (boolean)isSoap12);
                soapOperation.setSoapActionURI(operationName);
                boi.addExtensor((Object)soapOperation);
            }
            catch (WSDLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void removeOperation(String operationName) {
        ServiceInfo si = (ServiceInfo)this.server.getEndpoint().getService().getServiceInfos().get(0);
        InterfaceInfo ii = si.getInterface();
        String namespace = ii.getName().getNamespaceURI();
        OperationInfo oi = ii.getOperation(new QName(namespace, operationName));
        ii.removeOperation(oi);
        BindingInfo bi = (BindingInfo)si.getBindings().iterator().next();
        BindingOperationInfo boi = bi.getOperation(oi);
        bi.removeOperation(boi);
    }
}

