/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.job.controller.internal;

import java.util.concurrent.Callable;
import routines.system.api.ESBJobInterruptedException;
import routines.system.api.ESBProviderCallback;

public class LazyProviderCallbackDelegate
implements ESBProviderCallback {
    private final Callable<ESBProviderCallback> callable;
    private ESBProviderCallback delegate;
    private final Runnable shutdownRunnable;

    public LazyProviderCallbackDelegate(Callable<ESBProviderCallback> callable, Runnable shutdownAction) {
        this.callable = callable;
        this.shutdownRunnable = shutdownAction;
    }

    public synchronized Object getRequest() throws ESBJobInterruptedException {
        if (this.delegate == null) {
            try {
                this.delegate = this.callable.call();
            }
            catch (Exception e) {
                throw new RuntimeException("Can't get ESB Callback", e);
            }
        }
        return this.delegate.getRequest();
    }

    public void sendResponse(Object response) {
        if (this.delegate != null) {
            this.delegate.sendResponse(response);
        }
    }

    public void shutdown() {
        if (this.delegate != null) {
            this.shutdownRunnable.run();
        }
    }
}

