/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.job.controller.internal;

import java.util.ArrayList;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.saaj.SAAJFactoryResolver;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.databinding.source.SourceDataBinding;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxws.JaxWsClientFactoryBean;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.dom4j.Document;
import org.dom4j.io.DocumentResult;
import org.dom4j.io.DocumentSource;
import org.talend.esb.job.controller.internal.ESBProvider;
import org.w3c.dom.Node;
import routines.system.api.ESBConsumer;

@WebService
public class RuntimeESBConsumer
implements ESBConsumer {
    private final QName serviceName;
    private final QName portName;
    private final String operationName;
    private final String publishedEndpointUrl;
    private final boolean isRequestResponse;
    private final AbstractFeature serviceLocator;
    private final AbstractFeature serviceActivityMonitoring;
    private final Bus bus;

    public RuntimeESBConsumer(QName serviceName, QName portName, String operationName, String publishedEndpointUrl, boolean isRequestResponse, AbstractFeature serviceLocator, AbstractFeature serviceActivityMonitoring, Bus bus) {
        this.serviceName = serviceName;
        this.portName = portName;
        this.operationName = operationName;
        this.publishedEndpointUrl = publishedEndpointUrl;
        this.isRequestResponse = isRequestResponse;
        this.serviceLocator = serviceLocator;
        this.serviceActivityMonitoring = serviceActivityMonitoring;
        this.bus = bus;
    }

    public Object invoke(Object payload) throws Exception {
        if (payload instanceof Document) {
            Client client = this.createClient();
            try {
                Object[] result = client.invoke(this.operationName, new Object[]{new DocumentSource((Document)payload)});
                if (result != null) {
                    DocumentResult docResult = new DocumentResult();
                    TransformerFactory.newInstance().newTransformer().transform((Source)result[0], (Result)docResult);
                    return docResult.getDocument();
                }
            }
            catch (SoapFault e) {
                SOAPFault soapFault = RuntimeESBConsumer.createSoapFault((Exception)((Object)e));
                if (soapFault == null) {
                    throw new WebServiceException((Throwable)e);
                }
                SOAPFaultException exception = new SOAPFaultException(soapFault);
                if (e instanceof Fault && e.getCause() != null) {
                    exception.initCause(e.getCause());
                } else {
                    exception.initCause((Throwable)e);
                }
                throw exception;
            }
            return null;
        }
        throw new RuntimeException("Consumer try to send incompatible object: " + payload.getClass().getName());
    }

    private Client createClient() throws BusException, EndpointException {
        JaxWsClientFactoryBean cf = new JaxWsClientFactoryBean();
        cf.setServiceName(this.serviceName);
        cf.setEndpointName(this.portName);
        String endpointUrl = this.serviceLocator == null ? this.publishedEndpointUrl : "locator://" + this.serviceName.getLocalPart();
        cf.setAddress(endpointUrl);
        cf.setServiceClass(this.getClass());
        cf.setBus(this.bus);
        ArrayList<AbstractFeature> features = new ArrayList<AbstractFeature>();
        if (this.serviceLocator != null) {
            features.add(this.serviceLocator);
        }
        if (this.serviceActivityMonitoring != null) {
            features.add(this.serviceActivityMonitoring);
        }
        cf.setFeatures(features);
        Client client = cf.create();
        Service service = client.getEndpoint().getService();
        service.setDataBinding((DataBinding)new SourceDataBinding());
        ServiceInfo si = (ServiceInfo)service.getServiceInfos().get(0);
        InterfaceInfo ii = si.getInterface();
        ii.setName(this.serviceName);
        ESBProvider.addOperation(si, this.operationName, this.isRequestResponse);
        return client;
    }

    static SOAPFault createSoapFault(Exception ex) throws SOAPException {
        SOAPFault soapFault = SAAJFactoryResolver.createSOAPFactory(null).createFault();
        if (ex instanceof SoapFault) {
            if (!soapFault.getNamespaceURI().equals(((SoapFault)((Object)ex)).getFaultCode().getNamespaceURI()) && "http://schemas.xmlsoap.org/soap/envelope/".equals(((SoapFault)((Object)ex)).getFaultCode().getNamespaceURI())) {
                try {
                    soapFault = SAAJFactoryResolver.createSOAPFactory(null).createFault();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            soapFault.setFaultString(((SoapFault)((Object)ex)).getReason());
            soapFault.setFaultCode(((SoapFault)((Object)ex)).getFaultCode());
            soapFault.setFaultActor(((SoapFault)((Object)ex)).getRole());
            if (((SoapFault)((Object)ex)).getSubCode() != null) {
                soapFault.appendFaultSubcode(((SoapFault)((Object)ex)).getSubCode());
            }
            if (((SoapFault)((Object)ex)).hasDetails()) {
                Node nd = soapFault.getOwnerDocument().importNode(((SoapFault)((Object)ex)).getDetail(), true);
                nd = nd.getFirstChild();
                soapFault.addDetail();
                while (nd != null) {
                    Node next = nd.getNextSibling();
                    soapFault.getDetail().appendChild(nd);
                    nd = next;
                }
            }
        } else {
            String msg = ex.getMessage();
            if (msg != null) {
                soapFault.setFaultString(msg);
            }
        }
        return soapFault;
    }
}

