/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.job.controller.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.feature.AbstractFeature;
import org.talend.esb.job.controller.internal.ESBProvider;
import org.talend.esb.job.controller.internal.ESBProviderKey;
import org.talend.esb.job.controller.internal.LazyProviderCallbackDelegate;
import org.talend.esb.job.controller.internal.RuntimeESBConsumer;
import org.talend.esb.job.controller.internal.RuntimeESBProviderCallback;
import routines.system.api.ESBConsumer;
import routines.system.api.ESBEndpointInfo;
import routines.system.api.ESBEndpointRegistry;
import routines.system.api.ESBProviderCallback;
import routines.system.api.TalendESBJob;
import routines.system.api.TalendJob;

public class TalendJobLauncher
implements ESBEndpointRegistry {
    private static final String PUBLISHED_ENDPOINT_URL = "publishedEndpointUrl";
    private static final String DEFAULT_OPERATION_NAME = "defaultOperationName";
    private static final String SERVICE_NAME = "serviceName";
    private static final String PORT_NAME = "portName";
    private static final String COMMUNICATION_STYLE = "COMMUNICATION_STYLE";
    private static final String USE_SERVICE_LOCATOR = "useServiceLocator";
    private static final String USE_SERVICE_ACTIVITY_MONITOR = "useServiceActivityMonitor";
    private static final String VALUE_REQUEST_RESPONSE = "request-response";
    private static final String VALUE_ONE_WAY = "one-way";
    private static final Logger LOG = Logger.getLogger(TalendJobLauncher.class.getName());
    private final Map<ESBProviderKey, Collection<ESBProvider>> endpoints = new ConcurrentHashMap<ESBProviderKey, Collection<ESBProvider>>();
    private final Map<TalendJob, Thread> jobs = new ConcurrentHashMap<TalendJob, Thread>();
    private Bus bus;
    private AbstractFeature serviceLocator;
    private AbstractFeature serviceActivityMonitoring;

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public void setServiceLocator(AbstractFeature serviceLocator) {
        this.serviceLocator = serviceLocator;
    }

    public void setServiceActivityMonitoring(AbstractFeature serviceActivityMonitoring) {
        this.serviceActivityMonitoring = serviceActivityMonitoring;
    }

    public void runTalendJob(final TalendJob talendJob, final String[] args) {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    LazyProviderCallbackDelegate cb = null;
                    if (talendJob instanceof TalendESBJob) {
                        final TalendESBJob talendESBJob = (TalendESBJob)talendJob;
                        cb = new LazyProviderCallbackDelegate(new Callable<ESBProviderCallback>(){

                            @Override
                            public ESBProviderCallback call() throws Exception {
                                ESBEndpointInfo endpoint = talendESBJob.getEndpoint();
                                if (null != endpoint) {
                                    return TalendJobLauncher.this.createESBProvider(endpoint.getEndpointProperties());
                                }
                                throw new NullPointerException("TalendESBJob#getEndpoint() returned null");
                            }
                        }, new Runnable(){

                            @Override
                            public void run() {
                                ESBEndpointInfo endpoint = talendESBJob.getEndpoint();
                                if (endpoint != null) {
                                    TalendJobLauncher.this.destroyESBProvider(endpoint.getEndpointProperties());
                                }
                            }
                        });
                        talendESBJob.setProviderCallback((ESBProviderCallback)cb);
                        talendESBJob.setEndpointRegistry((ESBEndpointRegistry)TalendJobLauncher.this);
                    }
                    LOG.info("Talend Job starting...");
                    int ret = talendJob.runJobInTOS(args);
                    LOG.info("Talend Job finished with code " + ret);
                    if (cb != null) {
                        cb.shutdown();
                    }
                }
                finally {
                    TalendJobLauncher.this.jobs.remove(talendJob);
                }
            }
        });
        thread.setContextClassLoader(this.getClass().getClassLoader());
        thread.start();
        this.jobs.put(talendJob, thread);
    }

    public void stopTalendJob(TalendJob talendJob) {
        this.jobs.get(talendJob).interrupt();
    }

    private ESBProviderCallback createESBProvider(Map<String, Object> props) {
        QName portName;
        String publishedEndpointUrl = (String)props.get(PUBLISHED_ENDPOINT_URL);
        QName serviceName = QName.valueOf((String)props.get(SERVICE_NAME));
        ESBProviderKey key = new ESBProviderKey(serviceName, portName = QName.valueOf((String)props.get(PORT_NAME)));
        Collection<ESBProvider> esbProviders = this.endpoints.get(key);
        if (null == esbProviders) {
            esbProviders = new ArrayList<ESBProvider>(1);
            this.endpoints.put(key, esbProviders);
        }
        ESBProvider esbProvider = null;
        for (ESBProvider provider : esbProviders) {
            if (!publishedEndpointUrl.equals(provider.getPublishedEndpointUrl())) continue;
            esbProvider = provider;
            break;
        }
        if (esbProvider == null) {
            boolean useServiceLocator = (Boolean)props.get(USE_SERVICE_LOCATOR);
            boolean useServiceActivityMonitor = (Boolean)props.get(USE_SERVICE_ACTIVITY_MONITOR);
            esbProvider = new ESBProvider(publishedEndpointUrl, serviceName, portName, useServiceLocator ? this.serviceLocator : null, useServiceActivityMonitor ? this.serviceActivityMonitoring : null);
            esbProvider.run(this.bus);
            esbProviders.add(esbProvider);
        }
        String operationName = (String)props.get(DEFAULT_OPERATION_NAME);
        RuntimeESBProviderCallback esbProviderCallback = esbProvider.createESBProviderCallback(operationName, TalendJobLauncher.isRequestResponse((String)props.get(COMMUNICATION_STYLE)));
        return esbProviderCallback;
    }

    private void destroyESBProvider(Map<String, Object> props) {
        QName serviceName = QName.valueOf((String)props.get(SERVICE_NAME));
        QName portName = QName.valueOf((String)props.get(PORT_NAME));
        String publishedEndpointUrl = (String)props.get(PUBLISHED_ENDPOINT_URL);
        Collection<ESBProvider> esbProviders = this.endpoints.get(new ESBProviderKey(serviceName, portName));
        for (ESBProvider esbProvider : esbProviders) {
            if (!publishedEndpointUrl.equals(esbProvider.getPublishedEndpointUrl())) continue;
            String operationName = (String)props.get(DEFAULT_OPERATION_NAME);
            if (!esbProvider.destroyESBProviderCallback(operationName)) break;
            esbProviders.remove(esbProvider);
            break;
        }
    }

    public ESBConsumer createConsumer(ESBEndpointInfo endpoint) {
        Map props = endpoint.getEndpointProperties();
        QName serviceName = QName.valueOf((String)props.get(SERVICE_NAME));
        QName portName = QName.valueOf((String)props.get(PORT_NAME));
        String operationName = (String)props.get(DEFAULT_OPERATION_NAME);
        RuntimeESBConsumer esbConsumer = null;
        String publishedEndpointUrl = (String)props.get(PUBLISHED_ENDPOINT_URL);
        boolean useServiceLocator = (Boolean)props.get(USE_SERVICE_LOCATOR);
        boolean useServiceActivityMonitor = (Boolean)props.get(USE_SERVICE_ACTIVITY_MONITOR);
        esbConsumer = new RuntimeESBConsumer(serviceName, portName, operationName, publishedEndpointUrl, TalendJobLauncher.isRequestResponse((String)props.get(COMMUNICATION_STYLE)), useServiceLocator ? this.serviceLocator : null, useServiceActivityMonitor ? this.serviceActivityMonitoring : null, this.bus);
        return esbConsumer;
    }

    private static boolean isRequestResponse(String value) {
        if (VALUE_ONE_WAY.equals(value)) {
            return false;
        }
        if (VALUE_REQUEST_RESPONSE.equals(value)) {
            return true;
        }
        throw new RuntimeException("Unsupported communication style: " + value);
    }
}

