/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.job.controller.internal;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Logger;
import org.osgi.service.cm.ConfigurationException;

public class Configuration {
    public static final Logger LOG = Logger.getLogger(Configuration.class.getName());
    public static final String CONTEXT_PROP = "context";
    public static final String CONTEXT_OPT = "--context=";
    public static final String CONTEXT_PARAM_OPT = "--context_param=";
    List<String> argumentList = new ArrayList<String>();
    private String[] filter;

    public Configuration(Dictionary<?, ?> properties) throws ConfigurationException {
        this(properties, new String[0]);
    }

    public Configuration(Dictionary<?, ?> properties, String[] filter) throws ConfigurationException {
        this.filter = filter;
        if (properties != null) {
            Enumeration<?> keysEnum = properties.keys();
            while (keysEnum.hasMoreElements()) {
                String key = (String)keysEnum.nextElement();
                Object val = properties.get(key);
                if (!(val instanceof String)) {
                    throw new ConfigurationException(key, "Value is not of type String.");
                }
                this.addToArguments(key, (String)val);
            }
        }
    }

    private void addToArguments(String key, String value) {
        if (key.equals(CONTEXT_PROP)) {
            this.argumentList.add(CONTEXT_OPT + value);
            LOG.fine("Context " + value + " added to the argument list.");
        } else if (!this.isInFilter(key)) {
            this.argumentList.add(CONTEXT_PARAM_OPT + key + "=" + value);
            LOG.fine("Parameter " + key + " with value " + value + " added to the argument list.");
        } else {
            LOG.fine("Propertey " + key + " filltered out.");
        }
    }

    public String[] getArguments() {
        return this.argumentList.toArray(new String[this.argumentList.size()]);
    }

    private boolean isInFilter(String key) {
        for (String entry : this.filter) {
            if (!entry.equals(key)) continue;
            return true;
        }
        return false;
    }
}

