/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.job.controller.internal;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.osgi.service.cm.ConfigurationException;

public final class Configuration {
    public static final String CONTEXT_PROP = "context";
    public static final String CONTEXT_OPT = "--context=";
    public static final String CONTEXT_PARAM_OPT = "--context_param=";
    public static final String[] EMPTY_ARGUMENTS = new String[0];
    public static final long DEFAULT_TIMEOUT = 3000L;
    public static final String TIME_OUT_PROPERTY = "org.talend.esb.job.controller.configuration.timeout";
    private static final Logger LOG = Logger.getLogger(Configuration.class.getName());
    private static final String[] DEFAULT_FILTER = new String[0];
    private long timeout;
    private List<String> argumentList = new ArrayList<String>();
    private final CountDownLatch configAvailable = new CountDownLatch(1);
    private final String[] filter;

    public Configuration() {
        this(DEFAULT_FILTER);
    }

    public Configuration(Dictionary<?, ?> properties) throws ConfigurationException {
        this(properties, DEFAULT_FILTER);
    }

    public Configuration(String[] filter) {
        this.filter = filter;
        this.initTimeout();
    }

    public Configuration(Dictionary<?, ?> properties, String[] filter) throws ConfigurationException {
        this.filter = filter;
        this.setProperties(properties);
        this.initTimeout();
    }

    public void setProperties(Dictionary<?, ?> properties) throws ConfigurationException {
        ArrayList<String> newArgumentList = new ArrayList<String>();
        if (properties != null) {
            Enumeration<?> keysEnum = properties.keys();
            while (keysEnum.hasMoreElements()) {
                String key = (String)keysEnum.nextElement();
                Object val = properties.get(key);
                if (!(val instanceof String)) {
                    throw new ConfigurationException(key, "Value is not of type String.");
                }
                this.addToArguments(key, (String)val, newArgumentList);
            }
        }
        this.argumentList = newArgumentList;
        this.configAvailable.countDown();
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    private void addToArguments(String key, String value, List<String> argList) {
        if (key.equals(CONTEXT_PROP)) {
            argList.add(CONTEXT_OPT + value);
            LOG.fine("Context " + value + " added to the argument list.");
        } else if (!this.isInFilter(key)) {
            argList.add(CONTEXT_PARAM_OPT + key + "=" + value);
            LOG.fine("Parameter " + key + " with value " + value + " added to the argument list.");
        } else {
            LOG.fine("Propertey " + key + " filltered out.");
        }
    }

    public String[] awaitArguments() throws InterruptedException {
        String[] args = null;
        if (this.configAvailable.await(this.timeout, TimeUnit.MILLISECONDS)) {
            List<String> currentArgumentList = this.argumentList;
            args = currentArgumentList.toArray(new String[currentArgumentList.size()]);
        } else {
            args = EMPTY_ARGUMENTS;
            LOG.warning("ConfigAdmin did not pass any properties yet, returning an empty argumentlist.");
        }
        return args;
    }

    private void initTimeout() {
        this.timeout = Long.getLong(TIME_OUT_PROPERTY, 3000L);
    }

    private boolean isInFilter(String key) {
        for (String entry : this.filter) {
            if (!entry.equals(key)) continue;
            return true;
        }
        return false;
    }
}

