/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.job.controller.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedService;
import org.talend.esb.job.controller.GenericOperation;
import org.talend.esb.job.controller.JobLauncher;
import org.talend.esb.job.controller.internal.JobListener;
import org.talend.esb.job.controller.internal.JobTask;
import org.talend.esb.job.controller.internal.OperationTask;
import org.talend.esb.job.controller.internal.RouteAdapter;
import org.talend.esb.job.controller.internal.SimpleJobTask;
import routines.system.api.ESBEndpointRegistry;
import routines.system.api.TalendESBJob;
import routines.system.api.TalendESBRoute;
import routines.system.api.TalendJob;

public class JobLauncherImpl
implements JobLauncher,
JobListener {
    public static final Logger LOG = Logger.getLogger(JobLauncherImpl.class.getName());
    private BundleContext bundleContext;
    private ExecutorService executorService;
    private ESBEndpointRegistry endpointRegistry;
    private Map<String, JobTask> jobTasks = new ConcurrentHashMap<String, JobTask>();
    private Map<String, JobTask> routeTasks = new ConcurrentHashMap<String, JobTask>();
    private Map<String, TalendESBJob> esbJobs = new ConcurrentHashMap<String, TalendESBJob>();
    private Map<String, OperationTask> operationTasks = new ConcurrentHashMap<String, OperationTask>();
    private Map<String, ServiceRegistration> serviceRegistrations = new ConcurrentHashMap<String, ServiceRegistration>();

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public void setEndpointRegistry(ESBEndpointRegistry esbEndpointRegistry) {
        this.endpointRegistry = esbEndpointRegistry;
    }

    @Override
    public void esbJobAdded(TalendESBJob esbJob, String name) {
        LOG.info("Adding ESB job " + name + ".");
        esbJob.setEndpointRegistry(this.endpointRegistry);
        if (this.isConsumerOnly(esbJob)) {
            this.startJob((TalendJob)esbJob, name);
        } else {
            this.esbJobs.put(name, esbJob);
        }
    }

    @Override
    public void esbJobRemoved(TalendESBJob esbJob, String name) {
        LOG.info("Removing ESB job " + name + ".");
        if (this.isConsumerOnly(esbJob)) {
            this.stopJob((TalendJob)esbJob, name);
        } else {
            this.esbJobs.remove(name);
            OperationTask task = this.operationTasks.remove(name);
            if (task != null) {
                task.stop();
            }
        }
    }

    @Override
    public void routeAdded(TalendESBRoute route, String name) {
        LOG.info("Adding route " + name + ".");
        RouteAdapter adapter = new RouteAdapter(route, name);
        this.routeTasks.put(name, adapter);
        ServiceRegistration sr = this.bundleContext.registerService(ManagedService.class.getName(), (Object)adapter, this.getManagedServiceProperties(name));
        this.serviceRegistrations.put(name, sr);
        this.executorService.execute(adapter);
    }

    @Override
    public void routeRemoved(TalendESBRoute route, String name) {
        ServiceRegistration sr;
        LOG.info("Removing route " + name + ".");
        JobTask routeTask = this.routeTasks.remove(name);
        if (routeTask != null) {
            routeTask.stop();
        }
        if ((sr = this.serviceRegistrations.remove(name)) != null) {
            sr.unregister();
        }
    }

    @Override
    public void jobAdded(TalendJob job, String name) {
        LOG.info("Adding job " + name + ".");
        this.startJob(job, name);
    }

    @Override
    public void jobRemoved(TalendJob job, String name) {
        LOG.info("Removing job " + name + ".");
        this.stopJob(job, name);
    }

    public void unbind() {
        this.esbJobs.clear();
        this.executorService.shutdownNow();
    }

    private void startJob(TalendJob job, String name) {
        SimpleJobTask jobTask = new SimpleJobTask(job, name);
        this.jobTasks.put(name, jobTask);
        ServiceRegistration sr = this.bundleContext.registerService(ManagedService.class.getName(), (Object)jobTask, this.getManagedServiceProperties(name));
        this.serviceRegistrations.put(name, sr);
        this.executorService.execute(jobTask);
    }

    private void stopJob(TalendJob job, String name) {
        ServiceRegistration sr;
        JobTask jobTask = this.jobTasks.remove(name);
        if (jobTask != null) {
            jobTask.stop();
        }
        if ((sr = this.serviceRegistrations.remove(name)) != null) {
            sr.unregister();
        }
    }

    @Override
    public GenericOperation retrieveOperation(String jobName, String[] args) {
        OperationTask task = this.operationTasks.get(jobName);
        if (task == null) {
            TalendESBJob job = this.getJob(jobName);
            if (job == null) {
                throw new IllegalArgumentException("Talend job '" + jobName + "' not found");
            }
            task = new OperationTask(job, args);
            this.operationTasks.put(jobName, task);
            this.executorService.execute(task);
        }
        return task;
    }

    private TalendESBJob getJob(String name) {
        TalendESBJob job = this.esbJobs.get(name);
        if (job == null) {
            throw new IllegalArgumentException("Talend ESB job with name " + name + "' not found");
        }
        return job;
    }

    private Dictionary<String, Object> getManagedServiceProperties(String routeName) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        ((Dictionary)result).put("service.pid", routeName);
        return result;
    }

    private boolean isConsumerOnly(TalendESBJob esbJob) {
        return esbJob.getEndpoint() == null;
    }
}

