/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.job.controller.internal;

import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.talend.esb.job.controller.internal.JobListener;
import routines.system.api.TalendESBJob;
import routines.system.api.TalendESBRoute;
import routines.system.api.TalendJob;

public class JobTracker {
    private static final Logger LOG = Logger.getLogger(JobTracker.class.getName());
    private static final String FILTER = "(objectClass=" + TalendJob.class.getName() + ")";
    private static final String PROPERTY_KEY_NAME = "name";
    private BundleContext context;
    private JobListener listener;
    private ServiceTracker tracker;

    public void setJobListener(JobListener jobListener) {
        this.listener = jobListener;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.context = bundleContext;
    }

    public void bind() {
        LOG.fine("bind calling, creating and opening ServiceTracker...");
        Filter filter = null;
        try {
            filter = this.context.createFilter(FILTER);
        }
        catch (InvalidSyntaxException e) {
            LOG.throwing(this.getClass().getName(), "bind", e);
        }
        this.tracker = new ServiceTracker(this.context, filter, (ServiceTrackerCustomizer)new Customizer());
        this.tracker.open();
    }

    public void unbind() {
        LOG.fine("unbind calling, closing ServiceTracker...");
        if (this.tracker != null) {
            this.tracker.close();
        }
    }

    private String getValue(String name, ServiceReference sRef) {
        Object val = sRef.getProperty(name);
        if (!(name instanceof String)) {
            throw new IllegalArgumentException(name + " property of TalendJob either not defined or not of type String");
        }
        return (String)val;
    }

    private class Customizer
    implements ServiceTrackerCustomizer {
        private Customizer() {
        }

        public Object addingService(ServiceReference reference) {
            LOG.info("Service with reference " + reference + " added");
            Object service = JobTracker.this.context.getService(reference);
            if (service != null) {
                String name = JobTracker.this.getValue(JobTracker.PROPERTY_KEY_NAME, reference);
                if (service instanceof TalendESBJob) {
                    JobTracker.this.listener.esbJobAdded((TalendESBJob)service, name);
                } else if (service instanceof TalendESBRoute) {
                    JobTracker.this.listener.routeAdded((TalendESBRoute)service, name);
                } else if (service instanceof TalendJob) {
                    JobTracker.this.listener.jobAdded((TalendJob)service, name);
                }
            }
            return service;
        }

        public void modifiedService(ServiceReference reference, Object job) {
            LOG.info("Service " + job + " modified");
        }

        public void removedService(ServiceReference reference, Object service) {
            LOG.info("Service " + service + " removed");
            String name = JobTracker.this.getValue(JobTracker.PROPERTY_KEY_NAME, reference);
            if (service instanceof TalendESBJob) {
                JobTracker.this.listener.esbJobRemoved((TalendESBJob)service, name);
            } else if (service instanceof TalendESBRoute) {
                JobTracker.this.listener.routeRemoved((TalendESBRoute)service, name);
            } else if (service instanceof TalendJob) {
                JobTracker.this.listener.jobRemoved((TalendJob)service, name);
            }
            JobTracker.this.context.ungetService(reference);
        }
    }
}

