/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.job.controller.internal;

import java.util.Dictionary;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.talend.esb.job.controller.internal.Configuration;
import org.talend.esb.job.controller.internal.JobTask;
import routines.system.api.TalendESBRoute;

public class RouteAdapter
implements ManagedService,
JobTask {
    private static final Logger LOG = Logger.getLogger(RouteAdapter.class.getName());
    private final TalendESBRoute route;
    private final String name;
    private final Configuration configuration = new Configuration();

    public RouteAdapter(TalendESBRoute route, String name) {
        this.route = route;
        this.name = name;
    }

    public void updated(Dictionary properties) throws ConfigurationException {
        this.configuration.setProperties(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        LOG.info("Cancelling route " + this.name);
        ClassLoader oldContextCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.route.getClass().getClassLoader());
            this.route.shutdown();
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Shutting down route " + this.name + " caused an exception.", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOG.info("Starting route " + this.name);
        String[] args = null;
        try {
            args = this.configuration.awaitArguments();
        }
        catch (InterruptedException e) {
            return;
        }
        ClassLoader oldContextCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.route.getClass().getClassLoader());
            int ret = this.route.runJobInTOS(args);
            LOG.info("Route " + this.name + " finished, return code is " + ret);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextCL);
        }
    }
}

