/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.job.controller.internal;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;
import routines.system.api.ESBJobInterruptedException;
import routines.system.api.ESBProviderCallback;

public class RuntimeESBProviderCallback
implements ESBProviderCallback {
    public static final Logger LOG = Logger.getLogger(RuntimeESBProviderCallback.class.getName());
    private static final MessageExchange POISON = new MessageExchange(null);
    private final BlockingQueue<MessageExchange> requests = new LinkedBlockingQueue<MessageExchange>();
    private volatile MessageExchange currentExchange;
    private volatile boolean stopped;

    public Object getRequest() throws ESBJobInterruptedException {
        this.currentExchange = null;
        while (this.currentExchange == null) {
            try {
                this.currentExchange = this.requests.take();
                if (this.currentExchange != POISON) continue;
                this.stopped = true;
                throw new ESBJobInterruptedException("Job was cancelled.");
            }
            catch (InterruptedException e) {
                this.prepareStop();
            }
        }
        return this.currentExchange.request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendResponse(Object response) {
        this.currentExchange.response = response;
        MessageExchange messageExchange = this.currentExchange;
        synchronized (messageExchange) {
            this.currentExchange.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object payload, boolean isRequestResponse) throws Exception {
        MessageExchange myExchange = new MessageExchange(payload);
        this.requests.put(myExchange);
        if (!isRequestResponse) {
            return null;
        }
        MessageExchange messageExchange = myExchange;
        synchronized (messageExchange) {
            myExchange.wait();
        }
        return myExchange.response;
    }

    public void stop() {
        this.prepareStop();
    }

    public boolean isStopped() {
        return this.stopped;
    }

    protected void prepareStop() {
        boolean success = false;
        while (!success) {
            try {
                this.requests.put(POISON);
                success = true;
            }
            catch (InterruptedException e) {
                LOG.throwing(this.getClass().getName(), "prepareStop", e);
            }
        }
    }

    private static class MessageExchange {
        public Object request;
        public Object response;

        public MessageExchange(Object request) {
            this.request = request;
        }
    }
}

