/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.job.controller.internal;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.talend.esb.job.controller.internal.RuntimeESBProviderCallback;

public class MessageExchangeBuffer {
    public static final Logger LOG = Logger.getLogger(MessageExchangeBuffer.class.getName());
    private static final WorkloadListener DUMMY_LISTENER = new WorkloadListener(){

        @Override
        public void initialValues(MessageExchangeBuffer buffer, int consumersIdle, int waitingRequests) {
        }

        @Override
        public void valuesChanged(MessageExchangeBuffer buffer, int consumersIdle, int waitingRequests) {
        }
    };
    private static final RuntimeESBProviderCallback.MessageExchange POISON = new RuntimeESBProviderCallback.MessageExchange(null);
    private volatile Status status = Status.RUNNING;
    private final AtomicInteger idleConsumers = new AtomicInteger(0);
    private final BlockingQueue<RuntimeESBProviderCallback.MessageExchange> requests = new LinkedBlockingQueue<RuntimeESBProviderCallback.MessageExchange>();
    private WorkloadListener listener = DUMMY_LISTENER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RuntimeESBProviderCallback.MessageExchange take() throws BufferStoppedException, InterruptedException {
        RuntimeESBProviderCallback.MessageExchange currentExchange = null;
        try {
            this.idleConsumers.getAndIncrement();
            currentExchange = this.requests.take();
        }
        finally {
            this.idleConsumers.getAndDecrement();
        }
        if (this.status == Status.STOPPING && this.requests.size() <= 1) {
            this.status = Status.STOPPED;
        }
        if (currentExchange == POISON) {
            this.putPoison();
            throw new BufferStoppedException();
        }
        this.listener.valuesChanged(this, this.consumersIdle(), this.requestsWaiting());
        this.diagnose("Took one request from buffer.");
        return currentExchange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(RuntimeESBProviderCallback.MessageExchange messageExchange) throws InterruptedException, BufferStoppedException {
        Status status = this.status;
        synchronized (status) {
            if (!this.status.isRunning()) {
                throw new BufferStoppedException();
            }
            this.requests.put(messageExchange);
            this.listener.valuesChanged(this, this.consumersIdle(), this.requestsWaiting());
            this.diagnose("Put one request into buffer.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Status status = this.status;
        synchronized (status) {
            if (this.status.isRunning()) {
                this.putPoison();
                this.status = Status.STOPPING;
            }
        }
    }

    public boolean isStopped() {
        return this.status.isStopped();
    }

    public void setWorkloadListener(WorkloadListener workloadListener) {
        this.listener = workloadListener != null ? workloadListener : DUMMY_LISTENER;
        this.listener.initialValues(this, this.consumersIdle(), this.requestsWaiting());
    }

    public int consumersIdle() {
        return this.idleConsumers.get();
    }

    public int requestsWaiting() {
        int poisonItems = this.status.isRunning() ? 0 : 1;
        return this.requests.size() - poisonItems;
    }

    private void putPoison() {
        boolean success = false;
        while (!success) {
            try {
                this.requests.put(POISON);
                success = true;
            }
            catch (InterruptedException e) {
                LOG.throwing(this.getClass().getName(), "stop", e);
            }
        }
    }

    private void diagnose(String statusMsg) {
        if (LOG.isLoggable(Level.FINE)) {
            if (statusMsg != null && !statusMsg.isEmpty()) {
                LOG.fine(statusMsg);
            }
            LOG.fine(this.idleConsumers + " consumers waiting for requests," + this.requests.size() + " requests waiting to be processed.");
        }
    }

    public static class BufferStoppedException
    extends Exception {
        private static final long serialVersionUID = 6139255074631002393L;

        public BufferStoppedException() {
        }

        public BufferStoppedException(String message) {
            super(message);
        }
    }

    private static enum Status {
        RUNNING(0),
        STOPPING(1),
        STOPPED(2);

        private int id;

        private Status(int id) {
            this.id = id;
        }

        public boolean isRunning() {
            return this.id == 0;
        }

        public boolean isStopped() {
            return this.id == 2;
        }
    }

    public static interface WorkloadListener {
        public void initialValues(MessageExchangeBuffer var1, int var2, int var3);

        public void valuesChanged(MessageExchangeBuffer var1, int var2, int var3);
    }
}

