/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.job.controller.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPFault;
import javax.xml.transform.Source;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.databinding.source.SourceDataBinding;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.feature.LoggingFeature;
import org.apache.cxf.frontend.ClientFactoryBean;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxws.JaxWsClientFactoryBean;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.ws.policy.WSPolicyFeature;
import org.apache.cxf.ws.security.SecurityConstants;
import org.apache.cxf.ws.security.trust.STSClient;
import org.apache.neethi.Policy;
import org.dom4j.Document;
import org.talend.esb.job.controller.ESBEndpointConstants;
import org.talend.esb.job.controller.internal.SecurityArguments;
import org.talend.esb.job.controller.internal.WSPasswordCallbackHandler;
import org.talend.esb.job.controller.internal.util.DOM4JMarshaller;
import org.talend.esb.job.controller.internal.util.ServiceHelper;
import org.talend.esb.sam.agent.feature.EventFeature;
import org.talend.esb.sam.common.handler.impl.CustomInfoHandler;
import org.talend.esb.sam.common.spi.EventHandler;
import org.talend.esb.servicelocator.cxf.LocatorFeature;
import routines.system.api.ESBConsumer;

public class RuntimeESBConsumer
implements ESBConsumer {
    private static final Logger LOG = Logger.getLogger(RuntimeESBConsumer.class.getName());
    private static final String STS_WSDL_LOCATION = "sts.wsdl.location";
    private static final String STS_NAMESPACE = "sts.namespace";
    private static final String STS_SERVICE_NAME = "sts.service.name";
    private static final String STS_ENDPOINT_NAME = "sts.endpoint.name";
    private static final String CONSUMER_SIGNATURE_PASSWORD = "ws-security.signature.password";
    private final String operationName;
    private final boolean isRequestResponse;
    private final EventFeature samFeature;
    private final String soapAction;
    private final ClientFactoryBean clientFactory;

    public RuntimeESBConsumer(QName serviceName, QName portName, String operationName, String publishedEndpointUrl, boolean isRequestResponse, LocatorFeature slFeature, EventFeature samFeature, SecurityArguments securityArguments, Bus bus, boolean logging, String soapAction) {
        this.operationName = operationName;
        this.isRequestResponse = isRequestResponse;
        this.samFeature = samFeature;
        this.soapAction = soapAction;
        this.clientFactory = new JaxWsClientFactoryBean(){

            protected Endpoint createEndpoint() throws BusException, EndpointException {
                Endpoint endpoint = super.createEndpoint();
                InterfaceInfo ii = ((ServiceInfo)endpoint.getService().getServiceInfos().get(0)).getInterface();
                ii.setName(this.serviceName);
                return endpoint;
            }
        };
        this.clientFactory.setServiceName(serviceName);
        this.clientFactory.setEndpointName(portName);
        String endpointUrl = slFeature == null ? publishedEndpointUrl : "locator://" + serviceName.getLocalPart();
        this.clientFactory.setAddress(endpointUrl);
        this.clientFactory.setServiceClass(this.getClass());
        this.clientFactory.setBus(bus);
        ArrayList<Object> features = new ArrayList<Object>();
        if (slFeature != null) {
            features.add(slFeature);
        }
        if (samFeature != null) {
            features.add(samFeature);
        }
        if (null != securityArguments.getPolicy()) {
            features.add(new WSPolicyFeature(new Policy[]{securityArguments.getPolicy()}));
        }
        if (logging) {
            features.add(new LoggingFeature());
        }
        this.clientFactory.setFeatures(features);
        if (ESBEndpointConstants.EsbSecurity.TOKEN == securityArguments.getEsbSecurity()) {
            HashMap<String, String> properties = new HashMap<String, String>(2);
            properties.put("ws-security.username", securityArguments.getUsername());
            properties.put("ws-security.password", securityArguments.getPassword());
            this.clientFactory.setProperties(properties);
        } else if (ESBEndpointConstants.EsbSecurity.SAML == securityArguments.getEsbSecurity()) {
            Map<String, String> stsPropsDef = securityArguments.getStsProperties();
            STSClient stsClient = new STSClient(bus);
            stsClient.setWsdlLocation(stsPropsDef.get(STS_WSDL_LOCATION));
            stsClient.setServiceQName(new QName(stsPropsDef.get(STS_NAMESPACE), stsPropsDef.get(STS_SERVICE_NAME)));
            stsClient.setEndpointQName(new QName(stsPropsDef.get(STS_NAMESPACE), stsPropsDef.get(STS_ENDPOINT_NAME)));
            HashMap<String, String> stsProps = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : stsPropsDef.entrySet()) {
                if (!SecurityConstants.ALL_PROPERTIES.contains(entry.getKey())) continue;
                stsProps.put(entry.getKey(), entry.getValue());
            }
            stsProps.put("ws-security.username", securityArguments.getUsername());
            stsProps.put("ws-security.password", securityArguments.getPassword());
            stsClient.setProperties(stsProps);
            HashMap<String, Object> clientProps = new HashMap<String, Object>();
            clientProps.put("ws-security.sts.client", stsClient);
            Map<String, String> clientPropsDef = securityArguments.getClientProperties();
            for (Map.Entry<String, String> entry : clientPropsDef.entrySet()) {
                if (!SecurityConstants.ALL_PROPERTIES.contains(entry.getKey())) continue;
                clientProps.put(entry.getKey(), entry.getValue());
            }
            clientProps.put("ws-security.callback-handler", new WSPasswordCallbackHandler(clientPropsDef.get("ws-security.signature.username"), clientPropsDef.get(CONSUMER_SIGNATURE_PASSWORD)));
            this.clientFactory.setProperties(clientProps);
        }
    }

    public Object invoke(Object payload) throws Exception {
        if (payload instanceof Document) {
            return this.sendDocument((Document)payload);
        }
        if (payload instanceof Map) {
            Object samProps;
            Map map = (Map)payload;
            if (this.samFeature != null && (samProps = map.get("SAM-PROPS")) != null) {
                LOG.info("SAM custom properties received: " + samProps);
                CustomInfoHandler ciHandler = new CustomInfoHandler();
                ciHandler.setCustomInfo((Map)samProps);
                this.samFeature.setHandler((EventHandler)ciHandler);
            }
            return this.sendDocument((Document)map.get("PAYLOAD"));
        }
        throw new RuntimeException("Consumer try to send incompatible object: " + payload.getClass().getName());
    }

    private Object sendDocument(Document doc) throws Exception {
        Client client = this.createClient();
        try {
            Object[] result = client.invoke(this.operationName, new Object[]{DOM4JMarshaller.documentToSource(doc)});
            if (result != null) {
                Document document = DOM4JMarshaller.sourceToDocument((Source)result[0]);
                return document;
            }
        }
        catch (SoapFault e) {
            SOAPFault soapFault = ServiceHelper.createSoapFault((Exception)((Object)e));
            if (soapFault == null) {
                throw new WebServiceException((Throwable)e);
            }
            SOAPFaultException exception = new SOAPFaultException(soapFault);
            if (e instanceof Fault && e.getCause() != null) {
                exception.initCause(e.getCause());
            } else {
                exception.initCause((Throwable)e);
            }
            throw exception;
        }
        finally {
            client.destroy();
        }
        return null;
    }

    private Client createClient() throws BusException, EndpointException {
        Client client = this.clientFactory.create();
        Service service = client.getEndpoint().getService();
        service.setDataBinding((DataBinding)new SourceDataBinding());
        ServiceInfo si = (ServiceInfo)service.getServiceInfos().get(0);
        ServiceHelper.addOperation(si, this.operationName, this.isRequestResponse, this.soapAction);
        return client;
    }
}

