/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.job.controller.internal;

import java.util.concurrent.ExecutorService;
import java.util.logging.Logger;
import org.talend.esb.job.controller.internal.MessageExchangeBuffer;
import org.talend.esb.job.controller.internal.RuntimeESBProviderCallback;
import routines.system.api.ESBEndpointRegistry;
import routines.system.api.ESBProviderCallback;
import routines.system.api.TalendESBJob;

public class SingleInstanceWorkloadStrategy
implements MessageExchangeBuffer.WorkloadListener {
    public static final Logger LOG = Logger.getLogger(SingleInstanceWorkloadStrategy.class.getName());
    private final TalendESBJob job;
    private final String name;
    private String[] args;
    private final ESBEndpointRegistry registry;
    private final ExecutorService execService;
    private int instances;

    public SingleInstanceWorkloadStrategy(TalendESBJob esbJob, String jobName, String[] arguments, ESBEndpointRegistry endpointRegistry, ExecutorService executorService) {
        this.job = esbJob;
        this.name = jobName;
        this.args = arguments;
        this.registry = endpointRegistry;
        this.execService = executorService;
    }

    @Override
    public void initialValues(MessageExchangeBuffer buffer, int idleConsumers, int waitingRequests) {
        this.registerNewJobinstance(buffer);
    }

    @Override
    public void valuesChanged(MessageExchangeBuffer buffer, int idleConsumers, int waitingRequests) {
    }

    private void registerNewJobinstance(MessageExchangeBuffer buffer) {
        this.job.setEndpointRegistry(this.registry);
        RuntimeESBProviderCallback callback = new RuntimeESBProviderCallback(buffer, this.job, this.name, this.args);
        this.job.setProviderCallback((ESBProviderCallback)callback);
        this.execService.execute(callback);
        ++this.instances;
        LOG.info("Created instance " + this.instances + " of job " + this.name + ".");
    }
}

