/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.job.controller.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.osgi.service.cm.ConfigurationException;

public final class Configuration {
    private static final Logger LOG = Logger.getLogger(Configuration.class.getName());
    private static final String TIME_OUT_PROPERTY = "org.talend.esb.job.controller.configuration.timeout";
    private static final String CONTEXT_PROP = "context";
    private static final String CONTEXT_OPT = "--context=";
    private static final String CONTEXT_PARAM_OPT = "--context_param=";
    private static final String[] EMPTY_ARGUMENTS = new String[0];
    private static final long DEFAULT_TIMEOUT = 3000L;
    private static final String[] DEFAULT_FILTER = new String[0];
    private long timeout;
    private List<String> argumentList;
    private final CountDownLatch configAvailable = new CountDownLatch(1);
    private final List<String> filter;

    public Configuration() {
        this(DEFAULT_FILTER);
    }

    public Configuration(Dictionary<?, ?> properties) throws ConfigurationException {
        this(properties, DEFAULT_FILTER);
    }

    public Configuration(Dictionary<?, ?> properties, String[] filter) throws ConfigurationException {
        this(filter);
        this.setProperties(properties);
    }

    public Configuration(String[] filter) {
        this.filter = Arrays.asList(filter);
        this.initTimeout();
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setProperties(Dictionary<?, ?> properties) throws ConfigurationException {
        ArrayList<String> newArgumentList = new ArrayList<String>();
        if (properties != null) {
            Enumeration<?> keysEnum = properties.keys();
            while (keysEnum.hasMoreElements()) {
                String key = (String)keysEnum.nextElement();
                Object val = properties.get(key);
                if (val instanceof String) {
                    String strval = this.convertArgument(key, (String)val);
                    if (strval == null) continue;
                    newArgumentList.add(strval);
                    continue;
                }
                throw new ConfigurationException(key, "Value is not of type String.");
            }
        }
        this.argumentList = newArgumentList;
        this.configAvailable.countDown();
    }

    public String[] awaitArguments() throws InterruptedException {
        if (this.configAvailable.await(this.timeout, TimeUnit.MILLISECONDS)) {
            return this.argumentList.toArray(new String[this.argumentList.size()]);
        }
        LOG.warning("ConfigAdmin did not pass any properties yet, returning an empty argument list.");
        return EMPTY_ARGUMENTS;
    }

    private void initTimeout() {
        this.timeout = Long.getLong(TIME_OUT_PROPERTY, 3000L);
    }

    private String convertArgument(String key, String value) {
        if (key.equals(CONTEXT_PROP)) {
            LOG.fine("Context " + value + " added to the argument list.");
            return CONTEXT_OPT + value;
        }
        if (!this.filter.contains(key)) {
            LOG.fine("Parameter " + key + " with value " + value + " added to the argument list.");
            return CONTEXT_PARAM_OPT + key + "=" + value;
        }
        LOG.fine("Propertey " + key + " filltered out.");
        return null;
    }
}

