/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.job.controller.internal;

import java.util.concurrent.ExecutorService;
import java.util.logging.Logger;
import org.talend.esb.job.controller.internal.MessageExchangeBuffer;
import org.talend.esb.job.controller.internal.RuntimeESBProviderCallback;
import routines.system.api.ESBEndpointRegistry;
import routines.system.api.ESBProviderCallback;
import routines.system.api.TalendESBJob;
import routines.system.api.TalendESBJobFactory;

public class MultiInstanceWorkloadStrategy
implements MessageExchangeBuffer.WorkloadListener {
    public static final Logger LOG = Logger.getLogger(MultiInstanceWorkloadStrategy.class.getName());
    private final TalendESBJobFactory factory;
    private final String name;
    private String[] args;
    private final ESBEndpointRegistry registry;
    private final ExecutorService execService;
    private int instances;

    public MultiInstanceWorkloadStrategy(TalendESBJobFactory jobFactory, String jobName, String[] arguments, ESBEndpointRegistry endpointRegistry, ExecutorService executorService) {
        this.factory = jobFactory;
        this.name = jobName;
        this.args = arguments;
        this.registry = endpointRegistry;
        this.execService = executorService;
    }

    @Override
    public void initialValues(MessageExchangeBuffer buffer, int idleConsumers, int waitingRequests) {
        this.registerNewJobinstance(buffer);
    }

    @Override
    public void valuesChanged(MessageExchangeBuffer buffer, int idleConsumers, int waitingRequests) {
        if (idleConsumers == 0) {
            this.registerNewJobinstance(buffer);
        }
    }

    private void registerNewJobinstance(MessageExchangeBuffer buffer) {
        TalendESBJob job = this.factory.newTalendESBJob();
        job.setEndpointRegistry(this.registry);
        RuntimeESBProviderCallback callback = new RuntimeESBProviderCallback(buffer, job, this.name, this.args);
        job.setProviderCallback((ESBProviderCallback)callback);
        this.execService.execute(callback);
        ++this.instances;
        LOG.info("Created instance " + this.instances + " of job " + this.name + ".");
    }
}

