/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.job.controller.internal;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Resource;
import org.apache.cxf.Bus;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyRegistry;
import org.talend.esb.job.controller.PolicyProvider;

@NoJSR250Annotations(unlessNull={"bus"})
public class PolicyProviderImpl
implements PolicyProvider {
    private String policyToken;
    private String policySaml;
    private PolicyBuilder policyBuilder;

    public void setPolicyToken(String policyToken) {
        this.policyToken = policyToken;
    }

    public void setPolicySaml(String policySaml) {
        this.policySaml = policySaml;
    }

    @Resource
    public void setBus(Bus bus) {
        this.policyBuilder = (PolicyBuilder)bus.getExtension(PolicyBuilder.class);
    }

    @Override
    public Policy getTokenPolicy() {
        return this.loadPolicy(this.policyToken);
    }

    @Override
    public Policy getSamlPolicy() {
        return this.loadPolicy(this.policySaml);
    }

    @Override
    public void register(Bus cxf) {
        PolicyRegistry policyRegistry = ((PolicyEngine)cxf.getExtension(PolicyEngine.class)).getRegistry();
        policyRegistry.register("org.talend.esb.job.token.policy", this.getTokenPolicy());
        policyRegistry.register("org.talend.esb.job.saml.policy", this.getSamlPolicy());
    }

    private Policy loadPolicy(String location) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(location);
            Policy policy = this.policyBuilder.getPolicy((InputStream)is);
            return policy;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load policy", e);
        }
        finally {
            if (null != is) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {}
            }
        }
    }
}

