/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.job.controller.internal;

import java.util.Map;
import javax.annotation.Resource;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.neethi.Policy;
import org.talend.esb.job.controller.ESBEndpointConstants;
import org.talend.esb.job.controller.PolicyProvider;
import org.talend.esb.job.controller.internal.RuntimeESBConsumer;
import org.talend.esb.job.controller.internal.SecurityArguments;
import org.talend.esb.sam.agent.feature.EventFeature;
import org.talend.esb.servicelocator.cxf.LocatorFeature;
import routines.system.api.ESBConsumer;
import routines.system.api.ESBEndpointInfo;
import routines.system.api.ESBEndpointRegistry;

@NoJSR250Annotations(unlessNull={"bus"})
public class RuntimeESBEndpointRegistry
implements ESBEndpointRegistry {
    private static final String LOGGING = "logging";
    private Bus bus;
    private EventFeature samFeature;
    private PolicyProvider policyProvider;
    private Map<String, String> clientProperties;
    private Map<String, String> stsProperties;

    @Resource
    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public void setSamFeature(EventFeature samFeature) {
        this.samFeature = samFeature;
    }

    public void setPolicyProvider(PolicyProvider policyProvider) {
        this.policyProvider = policyProvider;
    }

    public void setClientProperties(Map<String, String> clientProperties) {
        this.clientProperties = clientProperties;
    }

    public void setStsProperties(Map<String, String> stsProperties) {
        this.stsProperties = stsProperties;
    }

    public ESBConsumer createConsumer(ESBEndpointInfo endpoint) {
        Map props = endpoint.getEndpointProperties();
        QName serviceName = QName.valueOf((String)props.get("serviceName"));
        QName portName = QName.valueOf((String)props.get("portName"));
        String operationName = (String)props.get("defaultOperationName");
        String publishedEndpointUrl = (String)props.get("publishedEndpointUrl");
        boolean useServiceLocator = (Boolean)props.get("useServiceLocator");
        boolean useServiceActivityMonitor = (Boolean)props.get("useServiceActivityMonitor");
        LocatorFeature slFeature = null;
        if (useServiceLocator) {
            slFeature = new LocatorFeature();
            Object slProps = props.get("SL-PROPS");
            if (slProps != null) {
                slFeature.setRequiredEndpointProperties((Map)slProps);
            }
        }
        ESBEndpointConstants.EsbSecurity esbSecurity = ESBEndpointConstants.EsbSecurity.fromString((String)props.get("esbSecurity"));
        Policy policy = null;
        if (ESBEndpointConstants.EsbSecurity.TOKEN == esbSecurity) {
            policy = this.policyProvider.getTokenPolicy();
        } else if (ESBEndpointConstants.EsbSecurity.SAML == esbSecurity) {
            policy = this.policyProvider.getSamlPolicy();
        }
        SecurityArguments securityArguments = new SecurityArguments(esbSecurity, policy, (String)props.get("username"), (String)props.get("password"), this.clientProperties, this.stsProperties);
        return new RuntimeESBConsumer(serviceName, portName, operationName, publishedEndpointUrl, ESBEndpointConstants.OperationStyle.isRequestResponse((String)props.get("COMMUNICATION_STYLE")), slFeature, useServiceActivityMonitor ? this.samFeature : null, securityArguments, this.bus, Boolean.parseBoolean(this.clientProperties.get(LOGGING)), (String)props.get("soapAction"));
    }
}

