/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.job.controller.internal;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.talend.esb.job.controller.internal.MessageExchangeBuffer;
import routines.system.api.ESBJobInterruptedException;
import routines.system.api.ESBProviderCallback;
import routines.system.api.TalendESBJob;

public class RuntimeESBProviderCallback
implements ESBProviderCallback,
Runnable {
    private static final Logger LOG = Logger.getLogger(RuntimeESBProviderCallback.class.getName());
    private MessageExchangeBuffer messageExchanges;
    private TalendESBJob job;
    private final String name;
    private MessageExchange currentExchange;
    private String[] arguments;

    public RuntimeESBProviderCallback(MessageExchangeBuffer messageExchanges, TalendESBJob esbJob, String jobName, String[] arguments) {
        this.messageExchanges = messageExchanges;
        this.job = esbJob;
        this.name = jobName;
        this.arguments = arguments;
    }

    public Object getRequest() throws ESBJobInterruptedException {
        try {
            this.currentExchange = this.messageExchanges.take();
        }
        catch (MessageExchangeBuffer.BufferStoppedException e) {
            Thread.currentThread().interrupt();
            throw new ESBJobInterruptedException("Job canceled.");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ESBJobInterruptedException("Job canceled.");
        }
        return this.currentExchange.getRequest();
    }

    public void sendResponse(Object response) {
        this.currentExchange.setResponse(response);
    }

    @Override
    public void run() {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Calling run to start ESB job instance " + this.job + " for job with name " + this.name);
        }
        ClassLoader oldContextCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.job.getClass().getClassLoader());
            while (true) {
                if (Thread.interrupted()) {
                    return;
                }
                LOG.info("Starting ESB job instance " + this.job + " for job with name " + this.name);
                int ret = this.job.runJobInTOS(this.arguments);
                LOG.info("ESB job instance " + this.job + " with name " + this.name + " finished, return code is " + ret);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextCL);
        }
    }

    public String toString() {
        return "RuntimeESBProviderCallback[" + System.identityHashCode(this) + "] for job " + this.job;
    }

    public static class MessageExchange {
        private Object request;
        private Object response;
        private boolean ready;

        public MessageExchange(Object request) {
            this.request = request;
        }

        public Object getRequest() {
            return this.request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setResponse(Object response) {
            MessageExchange messageExchange = this;
            synchronized (messageExchange) {
                this.response = response;
                this.ready = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object waitForResponse() throws InterruptedException {
            MessageExchange messageExchange = this;
            synchronized (messageExchange) {
                while (!this.ready) {
                    this.wait();
                }
            }
            return this.response;
        }
    }
}

