/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.job.controller.internal.util;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.model.SoapBindingInfo;
import org.apache.cxf.binding.soap.model.SoapOperationInfo;
import org.apache.cxf.binding.soap.saaj.SAAJFactoryResolver;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.w3c.dom.Node;

public final class ServiceHelper {
    private static final QName XSD_ANY_TYPE = new QName("http://www.w3.org/2001/XMLSchema", "anyType");

    private ServiceHelper() {
    }

    public static void addOperation(ServiceInfo si, String operationName, boolean isRequestResponse, String soapAction) {
        InterfaceInfo ii = si.getInterface();
        String namespace = ii.getName().getNamespaceURI();
        OperationInfo oi = ii.addOperation(new QName(namespace, operationName));
        MessageInfo mii = oi.createMessage(new QName(namespace, operationName + "Request"), MessageInfo.Type.INPUT);
        oi.setInput(operationName + "Request", mii);
        MessagePartInfo mpi = mii.addMessagePart("request");
        mpi.setTypeQName(XSD_ANY_TYPE);
        if (isRequestResponse) {
            MessageInfo mio = oi.createMessage(new QName(namespace, operationName + "Response"), MessageInfo.Type.OUTPUT);
            oi.setOutput(operationName + "Response", mio);
            mpi = mio.addMessagePart("response");
            mpi.setTypeQName(XSD_ANY_TYPE);
        }
        BindingInfo bi = (BindingInfo)si.getBindings().iterator().next();
        BindingOperationInfo boi = new BindingOperationInfo(bi, oi);
        if (soapAction != null && bi instanceof SoapBindingInfo) {
            SoapOperationInfo soi = new SoapOperationInfo();
            soi.setAction(soapAction);
            boi.addExtensor((Object)soi);
        }
        bi.addOperation(boi);
    }

    public static void removeOperation(ServiceInfo si, String operationName) {
        InterfaceInfo ii = si.getInterface();
        String namespace = ii.getName().getNamespaceURI();
        OperationInfo oi = ii.getOperation(new QName(namespace, operationName));
        ii.removeOperation(oi);
        BindingInfo bi = (BindingInfo)si.getBindings().iterator().next();
        BindingOperationInfo boi = bi.getOperation(oi);
        bi.removeOperation(boi);
    }

    public static SOAPFault createSoapFault(Exception ex) throws SOAPException {
        SOAPFault soapFault = SAAJFactoryResolver.createSOAPFactory(null).createFault();
        if (ex instanceof SoapFault) {
            if (!soapFault.getNamespaceURI().equals(((SoapFault)((Object)ex)).getFaultCode().getNamespaceURI()) && "http://schemas.xmlsoap.org/soap/envelope/".equals(((SoapFault)((Object)ex)).getFaultCode().getNamespaceURI())) {
                try {
                    soapFault = SAAJFactoryResolver.createSOAPFactory(null).createFault();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            soapFault.setFaultString(((SoapFault)((Object)ex)).getReason());
            soapFault.setFaultCode(((SoapFault)((Object)ex)).getFaultCode());
            soapFault.setFaultActor(((SoapFault)((Object)ex)).getRole());
            if (((SoapFault)((Object)ex)).getSubCode() != null) {
                soapFault.appendFaultSubcode(((SoapFault)((Object)ex)).getSubCode());
            }
            if (((SoapFault)((Object)ex)).hasDetails()) {
                Node nd = soapFault.getOwnerDocument().importNode(((SoapFault)((Object)ex)).getDetail(), true);
                nd = nd.getFirstChild();
                soapFault.addDetail();
                while (nd != null) {
                    Node next = nd.getNextSibling();
                    soapFault.getDetail().appendChild(nd);
                    nd = next;
                }
            }
        } else {
            String msg = ex.getMessage();
            if (msg != null) {
                soapFault.setFaultString(msg);
            }
        }
        return soapFault;
    }
}

