/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.job.controller.internal;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.security.trust.claims.ClaimsCallback;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ClaimValueCallbackHandler
implements CallbackHandler {
    private String claimValue;

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (!(callbacks[i] instanceof ClaimsCallback)) {
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
            ClaimsCallback callback = (ClaimsCallback)callbacks[i];
            callback.setClaims(this.createClaims());
        }
    }

    private Element createClaims() {
        Document doc = DOMUtils.createDocument();
        Element claimsElement = doc.createElementNS("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "Claims");
        claimsElement.setAttributeNS(null, "Dialect", "http://schemas.xmlsoap.org/ws/2005/05/identity");
        Element claimValueElement = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "ClaimValue");
        claimValueElement.setAttributeNS(null, "Uri", "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/role");
        Element value = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "Value");
        value.setTextContent(this.claimValue);
        claimValueElement.appendChild(value);
        claimsElement.appendChild(claimValueElement);
        return claimsElement;
    }

    public String getClaimValue() {
        return this.claimValue;
    }

    public void setClaimValue(String claimValue) {
        this.claimValue = claimValue;
    }
}

