/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.job.controller.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPFault;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.databinding.source.SourceDataBinding;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.feature.LoggingFeature;
import org.apache.cxf.frontend.ClientFactoryBean;
import org.apache.cxf.headers.Header;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxws.JaxWsClientFactoryBean;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.ws.policy.WSPolicyFeature;
import org.apache.cxf.ws.security.SecurityConstants;
import org.apache.cxf.ws.security.trust.STSClient;
import org.apache.cxf.wsdl.EndpointReferenceUtils;
import org.apache.neethi.Policy;
import org.dom4j.Document;
import org.talend.esb.job.controller.ESBEndpointConstants;
import org.talend.esb.job.controller.internal.ClaimValueCallbackHandler;
import org.talend.esb.job.controller.internal.SecurityArguments;
import org.talend.esb.job.controller.internal.WSPasswordCallbackHandler;
import org.talend.esb.job.controller.internal.util.DOM4JMarshaller;
import org.talend.esb.job.controller.internal.util.ServiceHelper;
import org.talend.esb.policy.correlation.feature.CorrelationIDFeature;
import org.talend.esb.sam.agent.feature.EventFeature;
import org.talend.esb.sam.common.handler.impl.CustomInfoHandler;
import org.talend.esb.sam.common.spi.EventHandler;
import org.talend.esb.servicelocator.cxf.LocatorFeature;
import routines.system.api.ESBConsumer;

public class RuntimeESBConsumer
implements ESBConsumer {
    private static final Logger LOG = Logger.getLogger(RuntimeESBConsumer.class.getName());
    private static final String STS_WSDL_LOCATION = "sts.wsdl.location";
    private static final String STS_X509_WSDL_LOCATION = "sts.x509.wsdl.location";
    private static final String STS_NAMESPACE = "sts.namespace";
    private static final String STS_SERVICE_NAME = "sts.service.name";
    private static final String STS_ENDPOINT_NAME = "sts.endpoint.name";
    private static final String STS_X509_ENDPOINT_NAME = "sts.x509.endpoint.name";
    private static final String CONSUMER_SIGNATURE_PASSWORD = "ws-security.signature.password";
    private final String operationName;
    private final boolean isRequestResponse;
    private final EventFeature samFeature;
    private final String soapAction;
    private final List<Header> soapHeaders;
    private AuthorizationPolicy authorizationPolicy;
    private final ClientFactoryBean clientFactory;
    private Client client;
    private boolean enhancedResponse;

    RuntimeESBConsumer(QName serviceName, QName portName, String operationName, String publishedEndpointUrl, String wsdlURL, boolean isRequestResponse, LocatorFeature slFeature, EventFeature samFeature, boolean useServiceRegistry, SecurityArguments securityArguments, Bus bus, boolean logging, String soapAction, List<Header> soapHeaders, boolean enhancedResponse, Object correlationIDCallbackHandler) {
        this.operationName = operationName;
        this.isRequestResponse = isRequestResponse;
        this.samFeature = samFeature;
        this.soapAction = soapAction;
        this.soapHeaders = soapHeaders;
        this.enhancedResponse = enhancedResponse;
        this.clientFactory = new JaxWsClientFactoryBean(){

            protected Endpoint createEndpoint() throws BusException, EndpointException {
                Endpoint endpoint = super.createEndpoint();
                InterfaceInfo ii = ((ServiceInfo)endpoint.getService().getServiceInfos().get(0)).getInterface();
                ii.setName(this.serviceName);
                return endpoint;
            }
        };
        this.clientFactory.setServiceName(serviceName);
        this.clientFactory.setEndpointName(portName);
        String endpointUrl = slFeature == null ? publishedEndpointUrl : "locator://" + serviceName.getLocalPart();
        this.clientFactory.setAddress(endpointUrl);
        if (null != wsdlURL) {
            this.clientFactory.setWsdlURL(wsdlURL);
        }
        this.clientFactory.setServiceClass(this.getClass());
        if (useServiceRegistry && !this.hasRegistryClientExtension(bus)) {
            SpringBusFactory sbf = new SpringBusFactory();
            bus = sbf.createBus();
        }
        this.clientFactory.setBus(bus);
        ArrayList<Object> features = new ArrayList<Object>();
        if (slFeature != null) {
            features.add(slFeature);
        }
        if (samFeature != null) {
            features.add(samFeature);
        }
        if (correlationIDCallbackHandler != null && !useServiceRegistry) {
            features.add(new CorrelationIDFeature());
        }
        if (null != securityArguments.getPolicy()) {
            features.add(new WSPolicyFeature(new Policy[]{securityArguments.getPolicy()}));
        }
        if (logging) {
            features.add(new LoggingFeature());
        }
        this.clientFactory.setFeatures(features);
        HashMap<String, Object> clientProps = new HashMap<String, Object>();
        if (ESBEndpointConstants.EsbSecurity.BASIC == securityArguments.getEsbSecurity()) {
            this.authorizationPolicy = new AuthorizationPolicy();
            this.authorizationPolicy.setUserName(securityArguments.getUsername());
            this.authorizationPolicy.setPassword(securityArguments.getPassword());
            this.authorizationPolicy.setAuthorizationType("Basic");
        } else if (ESBEndpointConstants.EsbSecurity.DIGEST == securityArguments.getEsbSecurity()) {
            this.authorizationPolicy = new AuthorizationPolicy();
            this.authorizationPolicy.setUserName(securityArguments.getUsername());
            this.authorizationPolicy.setPassword(securityArguments.getPassword());
            this.authorizationPolicy.setAuthorizationType("Digest");
        }
        if (ESBEndpointConstants.EsbSecurity.TOKEN == securityArguments.getEsbSecurity() || useServiceRegistry) {
            clientProps.put("ws-security.username", securityArguments.getUsername());
            clientProps.put("ws-security.password", securityArguments.getPassword());
        }
        if (ESBEndpointConstants.EsbSecurity.SAML == securityArguments.getEsbSecurity() || useServiceRegistry) {
            Object encryptUsername;
            Map<String, String> stsPropsDef = securityArguments.getStsProperties();
            STSClient stsClient = new STSClient(bus);
            stsClient.setServiceQName(new QName(stsPropsDef.get(STS_NAMESPACE), stsPropsDef.get(STS_SERVICE_NAME)));
            HashMap<String, Object> stsProps = new HashMap<String, Object>();
            for (Map.Entry<String, String> entry : stsPropsDef.entrySet()) {
                if (!SecurityConstants.ALL_PROPERTIES.contains(entry.getKey())) continue;
                stsProps.put(entry.getKey(), RuntimeESBConsumer.processFileURI(entry.getValue()));
            }
            if (null == securityArguments.getAlias()) {
                stsClient.setWsdlLocation(stsPropsDef.get(STS_WSDL_LOCATION));
                stsClient.setEndpointQName(new QName(stsPropsDef.get(STS_NAMESPACE), stsPropsDef.get(STS_ENDPOINT_NAME)));
                stsProps.put("ws-security.username", securityArguments.getUsername());
                stsProps.put("ws-security.password", securityArguments.getPassword());
            } else {
                stsClient.setWsdlLocation(stsPropsDef.get(STS_X509_WSDL_LOCATION));
                stsClient.setEndpointQName(new QName(stsPropsDef.get(STS_NAMESPACE), stsPropsDef.get(STS_X509_ENDPOINT_NAME)));
                stsProps.put("ws-security.sts.token.username", securityArguments.getAlias());
            }
            if (null != securityArguments.getRoleName() && securityArguments.getRoleName().length() != 0) {
                ClaimValueCallbackHandler roleCallbackHandler = new ClaimValueCallbackHandler();
                roleCallbackHandler.setClaimValue(securityArguments.getRoleName());
                stsClient.setClaimsCallbackHandler((CallbackHandler)roleCallbackHandler);
            }
            if (null != securityArguments.getSecurityToken()) {
                stsClient.setOnBehalfOf(securityArguments.getSecurityToken());
            }
            stsClient.setProperties(stsProps);
            clientProps.put("ws-security.sts.client", stsClient);
            Map<String, String> clientPropsDef = securityArguments.getClientProperties();
            for (Map.Entry<String, String> entry : clientPropsDef.entrySet()) {
                if (!SecurityConstants.ALL_PROPERTIES.contains(entry.getKey())) continue;
                clientProps.put(entry.getKey(), RuntimeESBConsumer.processFileURI(entry.getValue()));
            }
            if (null == securityArguments.getAlias()) {
                clientProps.put("ws-security.callback-handler", new WSPasswordCallbackHandler(clientPropsDef.get("ws-security.signature.username"), clientPropsDef.get(CONSUMER_SIGNATURE_PASSWORD)));
            } else {
                clientProps.put("ws-security.signature.username", securityArguments.getAlias());
                clientProps.put("ws-security.callback-handler", new WSPasswordCallbackHandler(securityArguments.getAlias(), securityArguments.getPassword()));
            }
            if (null != securityArguments.getCryptoProvider()) {
                clientProps.put("ws-security.encryption.crypto", securityArguments.getCryptoProvider());
            }
            if ((encryptUsername = clientProps.get("ws-security.encryption.username")) == null || encryptUsername.toString().isEmpty()) {
                clientProps.put("ws-security.encryption.username", serviceName.toString());
            }
        }
        clientProps.put("soap.no.validate.parts", Boolean.TRUE);
        clientProps.put("use.service.registry", Boolean.toString(useServiceRegistry));
        if (correlationIDCallbackHandler != null) {
            clientProps.put("correlation-id.callback-handler", correlationIDCallbackHandler);
        }
        this.clientFactory.setProperties(clientProps);
    }

    public Object invoke(Object payload) throws Exception {
        if (payload instanceof Document) {
            return this.sendDocument((Document)payload);
        }
        if (payload instanceof Map) {
            Object samProps;
            Map map = (Map)payload;
            if (this.samFeature != null && (samProps = map.get("SAM-PROPS")) != null) {
                LOG.info("SAM custom properties received: " + samProps);
                CustomInfoHandler ciHandler = new CustomInfoHandler();
                ciHandler.setCustomInfo((Map)samProps);
                this.samFeature.setHandler((EventHandler)ciHandler);
            }
            return this.sendDocument((Document)map.get("PAYLOAD"));
        }
        throw new RuntimeException("Consumer try to send incompatible object: " + payload.getClass().getName());
    }

    private Object sendDocument(Document doc) throws Exception {
        Client client = this.getClient();
        if (null != this.soapHeaders) {
            client.getRequestContext().put(Header.HEADER_LIST, this.soapHeaders);
        }
        try {
            Object[] result;
            Schema schema;
            Object svObj = client.getRequestContext().get("schema-validation-enabled");
            if (svObj instanceof String && ((String)svObj).equalsIgnoreCase("OUT") && null != (schema = EndpointReferenceUtils.getSchema((ServiceInfo)((ServiceInfo)client.getEndpoint().getService().getServiceInfos().get(0)), (Bus)client.getBus()))) {
                schema.newValidator().validate(DOM4JMarshaller.documentToSource(doc));
            }
            if ((result = client.invoke(this.operationName, new Object[]{DOM4JMarshaller.documentToSource(doc)})) != null) {
                Document response = DOM4JMarshaller.sourceToDocument((Source)result[0]);
                if (this.enhancedResponse) {
                    HashMap<String, Object> enhancedBody = new HashMap<String, Object>();
                    enhancedBody.put("payload", response);
                    enhancedBody.put("CorrelationID", client.getResponseContext().get("CorrelationID"));
                    return enhancedBody;
                }
                return response;
            }
        }
        catch (SoapFault e) {
            SOAPFault soapFault = ServiceHelper.createSoapFault((Exception)((Object)e));
            if (soapFault == null) {
                throw new WebServiceException((Throwable)e);
            }
            SOAPFaultException exception = new SOAPFaultException(soapFault);
            if (e instanceof Fault && e.getCause() != null) {
                exception.initCause(e.getCause());
            } else {
                exception.initCause((Throwable)e);
            }
            throw exception;
        }
        return null;
    }

    private Client getClient() throws BusException, EndpointException {
        if (this.client == null) {
            this.client = this.clientFactory.create();
            if (null != this.authorizationPolicy) {
                HTTPConduit conduit = (HTTPConduit)this.client.getConduit();
                conduit.setAuthorization(this.authorizationPolicy);
            }
            Service service = this.client.getEndpoint().getService();
            service.setDataBinding((DataBinding)new SourceDataBinding());
            ServiceInfo si = (ServiceInfo)service.getServiceInfos().get(0);
            ServiceHelper.addOperation(si, this.operationName, this.isRequestResponse, this.soapAction);
        }
        return this.client;
    }

    private boolean hasRegistryClientExtension(Bus bus) {
        return bus.hasExtensionByName("org.talend.esb.registry.client.wsdl.RegistryFactoryBeanListener") || bus.hasExtensionByName("org.talend.esb.registry.client.policy.RegistryFactoryBeanListener");
    }

    private static Object processFileURI(String fileURI) {
        if (fileURI.startsWith("file:")) {
            try {
                return new URL(fileURI);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return fileURI;
    }
}

