/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.job.controller.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import org.apache.cxf.Bus;
import org.apache.cxf.headers.Header;
import org.apache.neethi.Policy;
import org.apache.ws.security.components.crypto.Crypto;
import org.dom4j.Document;
import org.dom4j.io.DocumentSource;
import org.talend.esb.job.controller.ESBEndpointConstants;
import org.talend.esb.job.controller.PolicyProvider;
import org.talend.esb.job.controller.internal.RuntimeESBConsumer;
import org.talend.esb.job.controller.internal.SecurityArguments;
import org.talend.esb.sam.agent.feature.EventFeature;
import org.talend.esb.servicelocator.cxf.LocatorFeature;
import org.w3c.dom.Node;
import routines.system.api.ESBConsumer;
import routines.system.api.ESBEndpointInfo;
import routines.system.api.ESBEndpointRegistry;

public class RuntimeESBEndpointRegistry
implements ESBEndpointRegistry {
    private static final Logger LOG = Logger.getLogger(RuntimeESBEndpointRegistry.class.getName());
    private Bus bus;
    private EventFeature samFeature;
    private PolicyProvider policyProvider;
    private Map<String, String> clientProperties;
    private Map<String, String> stsProperties;
    private Crypto cryptoProvider;

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public void setSamFeature(EventFeature samFeature) {
        this.samFeature = samFeature;
    }

    public void setPolicyProvider(PolicyProvider policyProvider) {
        this.policyProvider = policyProvider;
    }

    public void setClientProperties(Map<String, String> clientProperties) {
        this.clientProperties = clientProperties;
    }

    public void setStsProperties(Map<String, String> stsProperties) {
        this.stsProperties = stsProperties;
    }

    public void setCryptoProvider(Crypto cryptoProvider) {
        this.cryptoProvider = cryptoProvider;
    }

    public ESBConsumer createConsumer(ESBEndpointInfo endpoint) {
        Map props = endpoint.getEndpointProperties();
        QName serviceName = QName.valueOf((String)props.get("serviceName"));
        QName portName = QName.valueOf((String)props.get("portName"));
        String operationName = (String)props.get("defaultOperationName");
        String publishedEndpointUrl = (String)props.get("publishedEndpointUrl");
        boolean useServiceLocator = (Boolean)props.get("useServiceLocator");
        boolean useServiceActivityMonitor = (Boolean)props.get("useServiceActivityMonitor");
        boolean useServiceRegistry = false;
        if (null != props.get("useServiceRegistry")) {
            useServiceRegistry = (Boolean)props.get("useServiceRegistry");
        }
        String authorizationRole = (String)props.get("role");
        boolean enhancedResponse = false;
        if (null != props.get("enhancedResponse")) {
            enhancedResponse = (Boolean)props.get("enhancedResponse");
        }
        boolean logMessages = false;
        if (null != props.get("logMessages")) {
            logMessages = (Boolean)props.get("logMessages");
        }
        LocatorFeature slFeature = null;
        if (useServiceLocator) {
            slFeature = new LocatorFeature();
            Object slProps = props.get("SL-PROPS");
            if (slProps != null) {
                slFeature.setRequiredEndpointProperties((Map)slProps);
            }
        }
        boolean useCrypto = false;
        if (null != props.get("useCrypto")) {
            useCrypto = (Boolean)props.get("useCrypto");
        }
        ESBEndpointConstants.EsbSecurity esbSecurity = ESBEndpointConstants.EsbSecurity.fromString((String)props.get("esbSecurity"));
        Policy policy = null;
        if (ESBEndpointConstants.EsbSecurity.TOKEN == esbSecurity) {
            policy = this.policyProvider.getUsernamePolicy(this.bus);
        } else if (ESBEndpointConstants.EsbSecurity.SAML == esbSecurity) {
            policy = null != authorizationRole ? (useCrypto ? this.policyProvider.getSAMLAuthzCryptoPolicy(this.bus) : this.policyProvider.getSAMLAuthzPolicy(this.bus)) : (useCrypto ? this.policyProvider.getSAMLCryptoPolicy(this.bus) : this.policyProvider.getSAMLPolicy(this.bus));
        }
        List<Header> soapHeaders = null;
        Object soapHeadersObject = props.get("soapHeaders");
        if (null != soapHeadersObject) {
            if (soapHeadersObject instanceof Document) {
                soapHeaders = new ArrayList();
                try {
                    DOMResult result = new DOMResult();
                    TransformerFactory.newInstance().newTransformer().transform((Source)new DocumentSource((Document)soapHeadersObject), result);
                    for (Node node = ((org.w3c.dom.Document)result.getNode()).getDocumentElement().getFirstChild(); node != null; node = node.getNextSibling()) {
                        if (1 != node.getNodeType()) continue;
                        soapHeaders.add(new Header(new QName(node.getNamespaceURI(), node.getLocalName()), (Object)node));
                    }
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "Uncaught exception during SOAP headers transformation: ", e);
                }
            } else if (soapHeadersObject instanceof List) {
                soapHeaders = (List)soapHeadersObject;
            }
        }
        SecurityArguments securityArguments = new SecurityArguments(esbSecurity, policy, (String)props.get("username"), (String)props.get("password"), (String)props.get("alias"), this.clientProperties, this.stsProperties, authorizationRole, props.get("securityToken"), (Crypto)(useCrypto || useServiceRegistry ? this.cryptoProvider : null));
        return new RuntimeESBConsumer(serviceName, portName, operationName, publishedEndpointUrl, (String)props.get("wsdlURL"), ESBEndpointConstants.OperationStyle.isRequestResponse((String)props.get("COMMUNICATION_STYLE")), slFeature, useServiceActivityMonitor ? this.samFeature : null, useServiceRegistry, securityArguments, this.bus, logMessages, (String)props.get("soapAction"), soapHeaders, enhancedResponse, props.get("correlation-id.callback-handler"));
    }
}

