/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.job.controller.internal;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.cxf.Bus;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyRegistry;
import org.talend.esb.job.controller.PolicyProvider;

public class PolicyProviderImpl
implements PolicyProvider {
    private Map<String, String> policyProperties;
    private Policy policyUsername;
    private Policy policySAML;
    private Policy policySAMLAuthz;
    private Policy policySAMLCrypto;
    private Policy policySAMLAuthzCrypto;

    public void setPolicyProperties(Map<String, String> policyProperties) {
        this.policyProperties = policyProperties;
    }

    @Override
    public Policy getUsernamePolicy(Bus cxf) {
        if (null == this.policyUsername) {
            this.policyUsername = this.loadPolicy(this.policyProperties.get("policy.username"), cxf);
        }
        return this.policyUsername;
    }

    @Override
    public Policy getSAMLPolicy(Bus cxf) {
        if (null == this.policySAML) {
            this.policySAML = this.loadPolicy(this.policyProperties.get("policy.saml"), cxf);
        }
        return this.policySAML;
    }

    @Override
    public Policy getSAMLAuthzPolicy(Bus cxf) {
        if (null == this.policySAMLAuthz) {
            this.policySAMLAuthz = this.loadPolicy(this.policyProperties.get("policy.saml.authz"), cxf);
        }
        return this.policySAMLAuthz;
    }

    @Override
    public Policy getSAMLCryptoPolicy(Bus cxf) {
        if (null == this.policySAMLCrypto) {
            this.policySAMLCrypto = this.loadPolicy(this.policyProperties.get("policy.saml.crypto"), cxf);
        }
        return this.policySAMLCrypto;
    }

    @Override
    public Policy getSAMLAuthzCryptoPolicy(Bus cxf) {
        if (null == this.policySAMLAuthzCrypto) {
            this.policySAMLAuthzCrypto = this.loadPolicy(this.policyProperties.get("policy.saml.authz.crypto"), cxf);
        }
        return this.policySAMLAuthzCrypto;
    }

    @Override
    public void register(Bus cxf) {
        PolicyRegistry policyRegistry = ((PolicyEngine)cxf.getExtension(PolicyEngine.class)).getRegistry();
        policyRegistry.register("org.talend.esb.job.token.policy", this.getUsernamePolicy(cxf));
        policyRegistry.register("org.talend.esb.job.saml.policy", this.getSAMLPolicy(cxf));
        policyRegistry.register("org.talend.esb.job.saml.authz.policy", this.getSAMLAuthzPolicy(cxf));
        policyRegistry.register("org.talend.esb.job.saml.crypto.policy", this.getSAMLCryptoPolicy(cxf));
        policyRegistry.register("org.talend.esb.job.saml.authz.crypto.policy", this.getSAMLAuthzCryptoPolicy(cxf));
    }

    private Policy loadPolicy(String location, Bus cxf) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(location);
            Policy policy = ((PolicyBuilder)cxf.getExtension(PolicyBuilder.class)).getPolicy((InputStream)is);
            return policy;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load policy", e);
        }
        finally {
            if (null != is) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {}
            }
        }
    }
}

