/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.job.controller.internal;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import org.talend.esb.job.controller.GenericOperation;
import org.talend.esb.job.controller.internal.AbstractOperation;
import org.talend.esb.job.controller.internal.MultiInstanceWorkloadStrategy;
import routines.system.api.ESBEndpointRegistry;
import routines.system.api.TalendESBJobFactory;

public class MultiThreadedOperation
extends AbstractOperation
implements GenericOperation {
    public static final Logger LOG = Logger.getLogger(MultiThreadedOperation.class.getName());
    private final ExecutorService execService;
    private final TalendESBJobFactory factory;
    private final String name;
    private final ESBEndpointRegistry endpointRegistry;
    private AtomicBoolean started = new AtomicBoolean(false);

    public MultiThreadedOperation(TalendESBJobFactory jobFactory, String jobName, ESBEndpointRegistry esbEndpointRegistry, ExecutorService executorService) {
        this.factory = jobFactory;
        this.name = jobName;
        this.endpointRegistry = esbEndpointRegistry;
        this.execService = executorService;
    }

    @Override
    public void start(String[] arguments) {
        boolean notStarted;
        boolean bl = notStarted = !this.started.getAndSet(true);
        if (notStarted) {
            this.start(new MultiInstanceWorkloadStrategy(this.factory, this.name, arguments, this.endpointRegistry, this.execService));
        }
    }
}

