/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.job.controller.internal;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.transform.Source;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.saaj.SAAJFactoryResolver;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.databinding.source.SourceDataBinding;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.feature.LoggingFeature;
import org.apache.cxf.frontend.ClientFactoryBean;
import org.apache.cxf.headers.Header;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.ws.policy.WSPolicyFeature;
import org.apache.cxf.ws.security.SecurityConstants;
import org.apache.cxf.ws.security.trust.STSClient;
import org.apache.cxf.wsdl.service.factory.AbstractServiceConfiguration;
import org.apache.neethi.Policy;
import org.dom4j.Document;
import org.talend.esb.job.controller.ESBEndpointConstants;
import org.talend.esb.job.controller.internal.SecurityArguments;
import org.talend.esb.job.controller.internal.util.DOM4JMarshaller;
import org.talend.esb.policy.correlation.feature.CorrelationIDFeature;
import org.talend.esb.sam.agent.feature.EventFeature;
import org.talend.esb.sam.common.handler.impl.CustomInfoHandler;
import org.talend.esb.sam.common.spi.EventHandler;
import org.talend.esb.security.saml.STSClientUtils;
import org.talend.esb.security.saml.WSPasswordCallbackHandler;
import org.talend.esb.servicelocator.cxf.LocatorFeature;
import org.w3c.dom.Node;
import routines.system.api.ESBConsumer;

public class RuntimeESBConsumer
implements ESBConsumer {
    private static final Logger LOG = Logger.getLogger(RuntimeESBConsumer.class.getName());
    private final QName operationName;
    private final EventFeature samFeature;
    private final List<Header> soapHeaders;
    private AuthorizationPolicy authorizationPolicy;
    private final ClientFactoryBean clientFactory;
    private Client client;
    private boolean enhancedResponse;

    RuntimeESBConsumer(QName serviceName, QName portName, final QName operationName, String publishedEndpointUrl, String wsdlURL, boolean isRequestResponse, LocatorFeature slFeature, EventFeature samFeature, boolean useServiceRegistry, SecurityArguments securityArguments, Bus bus, boolean logging, String soapAction, List<Header> soapHeaders, boolean enhancedResponse, Object correlationIDCallbackHandler) {
        String endpointUrl;
        this.operationName = operationName;
        this.samFeature = samFeature;
        this.soapHeaders = soapHeaders;
        this.enhancedResponse = enhancedResponse;
        this.clientFactory = new ClientFactoryBean();
        this.clientFactory.setServiceClass(GenericServiceClass.class);
        this.clientFactory.getServiceFactory().getServiceConfigurations().add(0, new AbstractServiceConfiguration(){

            public Boolean isOperation(Method method) {
                return "invoke".equals(method.getName());
            }

            public QName getOperationName(InterfaceInfo service, Method method) {
                return operationName;
            }

            public Boolean isWrapped() {
                return Boolean.FALSE;
            }
        });
        this.clientFactory.setServiceName(serviceName);
        this.clientFactory.setEndpointName(portName);
        String string = endpointUrl = slFeature == null ? publishedEndpointUrl : "locator://" + serviceName.getLocalPart();
        if (!useServiceRegistry) {
            this.clientFactory.setAddress(endpointUrl);
        }
        if (!useServiceRegistry && null != wsdlURL) {
            this.clientFactory.setWsdlURL(wsdlURL);
        }
        this.clientFactory.setDataBinding((DataBinding)new SourceDataBinding());
        this.clientFactory.setBus(bus);
        ArrayList<Object> features = new ArrayList<Object>();
        if (slFeature != null) {
            features.add(slFeature);
        }
        if (samFeature != null) {
            features.add(samFeature);
        }
        if (correlationIDCallbackHandler != null && !useServiceRegistry) {
            features.add(new CorrelationIDFeature());
        }
        if (null != securityArguments.getPolicy()) {
            features.add(new WSPolicyFeature(new Policy[]{securityArguments.getPolicy()}));
        }
        if (logging) {
            features.add(new LoggingFeature());
        }
        this.clientFactory.setFeatures(features);
        HashMap<String, Object> clientProps = new HashMap<String, Object>();
        if (ESBEndpointConstants.EsbSecurity.BASIC == securityArguments.getEsbSecurity()) {
            this.authorizationPolicy = new AuthorizationPolicy();
            this.authorizationPolicy.setUserName(securityArguments.getUsername());
            this.authorizationPolicy.setPassword(securityArguments.getPassword());
            this.authorizationPolicy.setAuthorizationType("Basic");
        } else if (ESBEndpointConstants.EsbSecurity.DIGEST == securityArguments.getEsbSecurity()) {
            this.authorizationPolicy = new AuthorizationPolicy();
            this.authorizationPolicy.setUserName(securityArguments.getUsername());
            this.authorizationPolicy.setPassword(securityArguments.getPassword());
            this.authorizationPolicy.setAuthorizationType("Digest");
        }
        if (ESBEndpointConstants.EsbSecurity.TOKEN == securityArguments.getEsbSecurity() || useServiceRegistry) {
            clientProps.put("security.username", securityArguments.getUsername());
            clientProps.put("security.password", securityArguments.getPassword());
        }
        if (ESBEndpointConstants.EsbSecurity.SAML == securityArguments.getEsbSecurity() || useServiceRegistry) {
            STSClient stsClient;
            HashMap<String, String> stsProps = new HashMap<String, String>(securityArguments.getStsProperties());
            if (null == securityArguments.getAlias()) {
                stsProps.put("security.username", securityArguments.getUsername());
                stsProps.put("security.password", securityArguments.getPassword());
                stsClient = STSClientUtils.createSTSClient((Bus)bus, stsProps);
            } else {
                stsProps.put("ws-security.sts.token.username", securityArguments.getAlias());
                stsClient = STSClientUtils.createSTSX509Client((Bus)bus, stsProps);
            }
            if (null != securityArguments.getRoleName() && securityArguments.getRoleName().length() != 0) {
                STSClientUtils.applyAuthorization((STSClient)stsClient, (String)securityArguments.getRoleName());
            }
            if (null != securityArguments.getSecurityToken()) {
                stsClient.setOnBehalfOf(securityArguments.getSecurityToken());
            }
            clientProps.put("ws-security.sts.client", stsClient);
            Map<String, String> clientPropsDef = securityArguments.getClientProperties();
            for (Map.Entry<String, String> entry : clientPropsDef.entrySet()) {
                if (!SecurityConstants.ALL_PROPERTIES.contains(entry.getKey())) continue;
                clientProps.put(entry.getKey(), RuntimeESBConsumer.processFileURI(entry.getValue()));
            }
            if (null == securityArguments.getAlias()) {
                String sigUser = clientPropsDef.get("security.signature.username");
                if (sigUser == null) {
                    sigUser = clientPropsDef.get("ws-security.signature.username");
                }
                clientProps.put("security.callback-handler", new WSPasswordCallbackHandler(sigUser, clientPropsDef.get("security.signature.password")));
            } else {
                clientProps.put("security.signature.username", securityArguments.getAlias());
                clientProps.put("security.callback-handler", new WSPasswordCallbackHandler(securityArguments.getAlias(), securityArguments.getPassword()));
            }
            if (null != securityArguments.getCryptoProvider()) {
                clientProps.put("security.encryption.crypto", securityArguments.getCryptoProvider());
                Object encryptUsername = clientProps.get("security.encryption.username");
                if (encryptUsername == null) {
                    encryptUsername = clientPropsDef.get("ws-security.encryption.username");
                }
                if (encryptUsername == null || encryptUsername.toString().isEmpty()) {
                    clientProps.put("security.encryption.username", serviceName.toString());
                }
            }
        }
        clientProps.put("soap.no.validate.parts", Boolean.TRUE);
        clientProps.put("use.service.registry", Boolean.toString(useServiceRegistry));
        if (correlationIDCallbackHandler != null) {
            clientProps.put("correlation-id.callback-handler", correlationIDCallbackHandler);
        }
        this.clientFactory.setProperties(clientProps);
    }

    public Object invoke(Object payload) throws Exception {
        if (payload instanceof Document) {
            return this.sendDocument((Document)payload);
        }
        if (payload instanceof Map) {
            Object samProps;
            Map map = (Map)payload;
            if (this.samFeature != null && (samProps = map.get("SAM-PROPS")) != null) {
                LOG.info("SAM custom properties received: " + samProps);
                CustomInfoHandler ciHandler = new CustomInfoHandler();
                ciHandler.setCustomInfo((Map)samProps);
                this.samFeature.setHandler((EventHandler)ciHandler);
            }
            return this.sendDocument((Document)map.get("PAYLOAD"));
        }
        throw new RuntimeException("Consumer try to send incompatible object: " + payload.getClass().getName());
    }

    private Object sendDocument(Document doc) throws Exception {
        Client client = this.getClient();
        if (null != this.soapHeaders) {
            client.getRequestContext().put(Header.HEADER_LIST, this.soapHeaders);
        }
        try {
            Object[] result = client.invoke(this.operationName, new Object[]{DOM4JMarshaller.documentToSource(doc)});
            if (result != null) {
                Document response = DOM4JMarshaller.sourceToDocument((Source)result[0]);
                if (this.enhancedResponse) {
                    HashMap<String, Object> enhancedBody = new HashMap<String, Object>();
                    enhancedBody.put("payload", response);
                    enhancedBody.put("CorrelationID", client.getResponseContext().get("CorrelationID"));
                    return enhancedBody;
                }
                return response;
            }
        }
        catch (SoapFault e) {
            SOAPFault soapFault = RuntimeESBConsumer.createSoapFault((Exception)((Object)e));
            if (soapFault == null) {
                throw new WebServiceException((Throwable)e);
            }
            SOAPFaultException exception = new SOAPFaultException(soapFault);
            if (e instanceof Fault && e.getCause() != null) {
                exception.initCause(e.getCause());
            } else {
                exception.initCause((Throwable)e);
            }
            throw exception;
        }
        return null;
    }

    private Client getClient() throws BusException, EndpointException {
        if (this.client == null) {
            this.client = this.clientFactory.create();
            if (null != this.authorizationPolicy) {
                HTTPConduit conduit = (HTTPConduit)this.client.getConduit();
                conduit.setAuthorization(this.authorizationPolicy);
            }
        }
        return this.client;
    }

    private static Object processFileURI(String fileURI) {
        if (fileURI.startsWith("file:")) {
            try {
                return new URL(fileURI);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return fileURI;
    }

    private static SOAPFault createSoapFault(Exception ex) throws SOAPException {
        SOAPFault soapFault = SAAJFactoryResolver.createSOAPFactory(null).createFault();
        if (ex instanceof SoapFault) {
            if (!soapFault.getNamespaceURI().equals(((SoapFault)((Object)ex)).getFaultCode().getNamespaceURI()) && "http://schemas.xmlsoap.org/soap/envelope/".equals(((SoapFault)((Object)ex)).getFaultCode().getNamespaceURI())) {
                try {
                    soapFault = SAAJFactoryResolver.createSOAPFactory(null).createFault();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            soapFault.setFaultString(((SoapFault)((Object)ex)).getReason());
            soapFault.setFaultCode(((SoapFault)((Object)ex)).getFaultCode());
            soapFault.setFaultActor(((SoapFault)((Object)ex)).getRole());
            if (((SoapFault)((Object)ex)).getSubCode() != null) {
                soapFault.appendFaultSubcode(((SoapFault)((Object)ex)).getSubCode());
            }
            if (((SoapFault)((Object)ex)).hasDetails()) {
                Node nd = soapFault.getOwnerDocument().importNode(((SoapFault)((Object)ex)).getDetail(), true);
                nd = nd.getFirstChild();
                soapFault.addDetail();
                while (nd != null) {
                    Node next = nd.getNextSibling();
                    soapFault.getDetail().appendChild(nd);
                    nd = next;
                }
            }
        } else {
            String msg = ex.getMessage();
            if (msg != null) {
                soapFault.setFaultString(msg);
            }
        }
        return soapFault;
    }

    static interface GenericServiceClass {
        public Object invoke(Object var1);
    }
}

