/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.job.controller.internal;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class JobExecutorFactory {
    public static final Logger LOG = Logger.getLogger(JobExecutorFactory.class.getName());
    private static Thread.UncaughtExceptionHandler loggingUEH = new Thread.UncaughtExceptionHandler(){

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            LOG.log(Level.SEVERE, "Uncaught exception in job executor thread: ", e);
        }
    };

    private JobExecutorFactory() {
    }

    public static ExecutorService newExecutor() {
        ThreadFactory jobThreadFactory = new ThreadFactory(){
            ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();

            @Override
            public Thread newThread(Runnable r) {
                Thread newThread = this.defaultThreadFactory.newThread(r);
                newThread.setUncaughtExceptionHandler(loggingUEH);
                newThread.setContextClassLoader(this.getClass().getClassLoader());
                return newThread;
            }
        };
        return Executors.newCachedThreadPool(jobThreadFactory);
    }
}

