/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.job.controller.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedService;
import org.talend.esb.job.controller.GenericOperation;
import org.talend.esb.job.controller.JobLauncher;
import org.talend.esb.job.controller.internal.JobListener;
import org.talend.esb.job.controller.internal.JobTask;
import org.talend.esb.job.controller.internal.MultiThreadedOperation;
import org.talend.esb.job.controller.internal.RouteAdapter;
import org.talend.esb.job.controller.internal.SimpleJobTask;
import org.talend.esb.job.controller.internal.SingleThreadedOperation;
import routines.system.api.ESBEndpointRegistry;
import routines.system.api.TalendESBJob;
import routines.system.api.TalendESBJobFactory;
import routines.system.api.TalendESBRoute;
import routines.system.api.TalendJob;

public class JobLauncherImpl
implements JobLauncher,
JobListener {
    public static final Logger LOG = Logger.getLogger(JobLauncherImpl.class.getName());
    private BundleContext bundleContext;
    private ExecutorService executorService;
    private ESBEndpointRegistry endpointRegistry;
    private Map<String, JobTask> jobTasks = new ConcurrentHashMap<String, JobTask>();
    private Map<String, JobTask> routeTasks = new ConcurrentHashMap<String, JobTask>();
    private Map<String, GenericOperation> operations = new ConcurrentHashMap<String, GenericOperation>();
    private Map<String, ServiceRegistration> serviceRegistrations = new ConcurrentHashMap<String, ServiceRegistration>();

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public void setEndpointRegistry(ESBEndpointRegistry esbEndpointRegistry) {
        this.endpointRegistry = esbEndpointRegistry;
    }

    @Override
    public void esbJobFactoryAdded(TalendESBJobFactory esbJobFactory, String name) {
        LOG.info("Adding ESB job factory for job " + name + ".");
        MultiThreadedOperation op = new MultiThreadedOperation(esbJobFactory, name, this.endpointRegistry, this.executorService);
        this.operations.put(name, op);
        if (esbJobFactory instanceof TalendESBJob) {
            ((TalendESBJob)esbJobFactory).setEndpointRegistry(this.endpointRegistry);
        }
    }

    @Override
    public void esbJobAdded(TalendESBJob esbJob, String name) {
        LOG.info("Adding ESB job " + name + ".");
        esbJob.setEndpointRegistry(this.endpointRegistry);
        if (this.isConsumerOnly(esbJob)) {
            this.startJob((TalendJob)esbJob, name);
        } else {
            SingleThreadedOperation op = new SingleThreadedOperation(esbJob, name, this.endpointRegistry, this.executorService);
            this.operations.put(name, op);
        }
    }

    @Override
    public void esbJobRemoved(TalendESBJob esbJob, String name) {
        LOG.info("Removing ESB job " + name + ".");
        if (this.isConsumerOnly(esbJob)) {
            this.stopJob((TalendJob)esbJob, name);
        } else {
            GenericOperation task = this.operations.remove(name);
            if (task != null) {
                task.stop();
            }
        }
    }

    @Override
    public void esbJobFactoryRemoved(TalendESBJobFactory esbJobFactory, String name) {
        LOG.info("Removing ESB job factory for job " + name + ".");
        GenericOperation task = this.operations.remove(name);
        if (task != null) {
            task.stop();
        }
    }

    @Override
    public void routeAdded(TalendESBRoute route, String name) {
        LOG.info("Adding route " + name + ".");
        RouteAdapter adapter = new RouteAdapter(route, name);
        this.routeTasks.put(name, adapter);
        ServiceRegistration sr = this.bundleContext.registerService(ManagedService.class.getName(), (Object)adapter, this.getManagedServiceProperties(name));
        this.serviceRegistrations.put(name, sr);
        this.executorService.execute(adapter);
    }

    @Override
    public void routeRemoved(TalendESBRoute route, String name) {
        ServiceRegistration sr;
        LOG.info("Removing route " + name + ".");
        JobTask routeTask = this.routeTasks.remove(name);
        if (routeTask != null) {
            routeTask.stop();
        }
        if ((sr = this.serviceRegistrations.remove(name)) != null) {
            sr.unregister();
        }
    }

    @Override
    public void jobAdded(TalendJob job, String name) {
        LOG.info("Adding job " + name + ".");
        this.startJob(job, name);
    }

    @Override
    public void jobRemoved(TalendJob job, String name) {
        LOG.info("Removing job " + name + ".");
        this.stopJob(job, name);
    }

    public void unbind() {
        this.executorService.shutdownNow();
    }

    private void startJob(TalendJob job, String name) {
        SimpleJobTask jobTask = new SimpleJobTask(job, name);
        this.jobTasks.put(name, jobTask);
        ServiceRegistration sr = this.bundleContext.registerService(ManagedService.class.getName(), (Object)jobTask, this.getManagedServiceProperties(name));
        this.serviceRegistrations.put(name, sr);
        this.executorService.execute(jobTask);
    }

    private void stopJob(TalendJob job, String name) {
        ServiceRegistration sr;
        JobTask jobTask = this.jobTasks.remove(name);
        if (jobTask != null) {
            jobTask.stop();
        }
        if ((sr = this.serviceRegistrations.remove(name)) != null) {
            sr.unregister();
        }
    }

    @Override
    public synchronized GenericOperation retrieveOperation(String jobName, String[] args) {
        GenericOperation task = this.operations.get(jobName);
        if (task == null) {
            throw new IllegalArgumentException("Talend ESB job with name " + jobName + "' not found");
        }
        task.start(args);
        return task;
    }

    private Dictionary<String, Object> getManagedServiceProperties(String routeName) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        ((Dictionary)result).put("service.pid", routeName);
        return result;
    }

    private boolean isConsumerOnly(TalendESBJob esbJob) {
        return esbJob.getEndpoint() == null;
    }
}

